function [ lambda, beta ] = uMvn1(dat,phi, beta)
%UPDATE the mean parameter of a multivariate normal distribution.
n=size(dat,2);
%%%% multinomial gibbs - no integration
sigma=1/sum(phi.*beta.^2);
mu=sum(dat.*repmat(phi,1,n).*repmat(beta,1,n),1)*sigma;
lambda=mvnrnd(mu,sigma*eye(n));
l=sqrt(sum(lambda.^2));
lambda=lambda*sqrt(n)/l;
beta=beta*l/sqrt(n);

end

