function [ tau phi ] = uMvn2( dat, lambda, alpha, beta, maximize )

if(nargin==4)
    maximize=0;
end;

N=size(dat,2);
nl2=sum(lambda.^2);
lambda=lambda/sqrt(nl2);
nDat=sum(dat.^2,2);
dat=dat./repmat(sqrt(nDat),1,N);

alpha=(N-1)/2 + alpha;
beta=nDat/2.*(2*beta./nDat+1-(dat*lambda').^2);
phi=gamrnd(alpha,1./beta);
if(maximize)
    phi=(alpha-1)./beta;
end;

tau=normrnd(sqrt(nDat).*(dat*lambda')/sqrt(nl2),1./sqrt(phi*nl2));
if(maximize)
    tau=sqrt(nDat).*(dat*lambda')/sqrt(nl2);
end;
%     atWt=sum(lambda.^2)+1;
%     m=(dat*lambda')/atWt;
%     alpha=size(dat,2)/2+iga;
%     gamma=(sum(dat.^2,2)-atWt*m.^2)/2+igb;
%     phi=gamrnd(alpha,1./gamma);
%     beta=normrnd(m,sqrt(1./(phi*atWt)));
end

