function [ C ] = mergeKeep( A, B, bya, byb )
%MERGEKEEP Summary of this function goes here
%   Detailed explanation goes here

if(nargin==2)
    bya=1;
    byb=1;
end;

A=sortrows(A,bya);
B=sortrows(B,byb);

if(isnumeric(A) | iscellstr(A(1,bya)))
    [int, ia, ib]=intersect(A(:,bya),B(:,byb));    
else
    a=cell2mat(A(:,bya));
    b=cell2mat(B(:,byb));
    [int, ia, ib]=intersect(a,b);
end;
notBya=1:size(A,2);
notBya(bya)=[];
notByb=1:size(B,2);
notByb(byb)=[];

aNoMatch=1:size(A,1);
aNoMatch(ia)=[];
bNoMatch=1:size(B,1);
bNoMatch(ib)=[];

C=[A(ia,bya) A(ia,notBya) B(ib,notByb)];
if(isnumeric(A))
    C=[C;A(aNoMatch,bya) A(aNoMatch,notBya) NaN(length(aNoMatch),size(B,2)-1)];
else
    C=[C;A(aNoMatch,bya) A(aNoMatch,notBya) cell(length(aNoMatch),size(B,2)-1)];
end;

if(isnumeric(B))
    C=[C;B(bNoMatch,byb) B(bNoMatch,notByb) NaN(length(aNoMatch),size(A,2)-1)];
else
    C=[C;B(aNoMatch,byb) B(bNoMatch,notByb) cell(length(aNoMatch),size(A,2)-1)];
end;

C=sortrows(C);

