function [ mu ] = mvNormalMean( mu0, sigma, kappa, x )
%updates the mean of a multivariate normal with prior mean mu0 (Px1), 
%prior precision matrix phiMu (PxP), and
%observations x (PxN) from distribution with precision matrix phiX (PxP).

[p n]=size(x);
% mu=mvnrnd( kappa*mu0/(kappa+n)+n*mean(x,2)/(kappa+n) ,sigma/(kappa+n));
nsig=inv(sigma+n*kappa);
mu=mvnrnd( nsig*(sigma*mu0+sum(kappa*x,2)) ,nsig);
