function [ Sigma ] = mvNormalPrecision( Phi0, df, z )
%updates the mean of a multivariate normal with prior mean mu0 (Px1), 
%prior precision matrix phiMu (PxP), and
%observations x (PxN) from distribution with precision matrix phiX (PxP).

[p n]=size(z);

V=zeros(p,p);
for(i=1:n)
    V=V+z(:,i)*z(:,i)';
end;
V=V+inv(Phi0);
V=inv(V);
Sigma=wishrnd((V+V')/2,df+n);
