function [ idx ] = mvtMixtureMembership( mu, sigma, df, p, x )
% accepts: mu - NxK, a matrix of means, one column for each element in the
% mixture of normals distribution.  sigma - (N^2)xk, a matrix of covariances, each column
% should be of size NxN and contain the entries in the covariance matrix.
% df - Kx1, the degress of freedom of the multivariate t distributions.
% p - Kx1, the prior probabilities for assignment in each of the elements in the
% mixture.  x - NxP, the data points, one column for each observation.  An
% optional parameter, dimkp - NxK, lists the dimensions to disregard for
% each mixture component.
% Return value is idx - Px1 list of group assignments.

if(size(p,1)==1)
    p=p';
end;

[N P]=size(x);
[N K]=size(mu);
ll=zeros(K,P);
sig=zeros(N,N);
idx=zeros(P,1);

for(j=1:K)
    sig(:)=sigma(:,j);
    ll(j,:)=logmvtpdf(x,mu(:,j),sig,df(j));
end;
for(i=1:P)
    idx(i)=randsample(K,1,true,exp(ll(:,i)-max(ll(:,i))).*p);
end;
