function [ idx ] = normMixtureMembership( mu, sigma, p, x )
% accepts: mu - NxK, a matrix of means, one column for each element in the
% mixture of normals distribution.  sigma - (N^2)xk, a matrix of covariances, each column
% should be of size NxN and contain the entries in the covariance matrix.
% p - Kx1, the prior probabilities for assignment in each of the elements in the
% mixture.  x - NxP, the data points, one column for each observation.
% Return value is idx - Px1 list of assignments.

[N P]=size(x);
[N K]=size(mu);
ll=zeros(K,1);
sig=zeros(N,N);
idx=zeros(P,1);

for(i=1:P)
    for(j=1:K)
        sig(:)=sigma(:,j);
        ll(j)=logmvnpdf(x(:,i),mu(:,j),sig);
    end;
    idx(i)=randsample(K,1,true,exp(ll-max(ll)).*p);
end;