function [ ] = groupPlot( x,g,g2 )
%GROUPPLOT Plots the vector x with colors determined by g and symbols
%determined by g2.  Sorts first by g, then by g2.

if(nargin<3)
    g2=ones(size(g));
end;

if(isnumeric(g) & isnumeric(g2))
    nanlist=find(isnan(x) | isnan(g) | isnan(g2));
else
    nanlist=find(isnan(x));
end;
if(length(nanlist)>0)
    'Dropping NaN observations from plot variable.'
    x(nanlist)=[];
    g(nanlist)=[];
    g2(nanlist)=[];
end;

[a b c]=unique(g);
numG=1:length(a);
numG=numG(c)';

if(nargin>2)
    [g2l jk d]=unique(g2);
    if(length(g2l)==1)
        ng2=ones(length(g2),1);
    else
        ng2=1:length(g2l);
        ng2=ng2(d)';
    end;
else
    ng2=ones(size(numG));
end;
[jnk ord]=sortrows([numG ng2]);
x=x(ord);
ng2=ng2(ord);
numG=numG(ord);
g=g(ord);
g2=g2(ord);
[a b c]=unique(g);

if(length(unique(g))<=7)
    col=exp_colormap();
    col='brkgmcybrkgmcybrkgmcybrkgmcybrkgmcy';
    col=col';
else
    col=colormap();
    col=col(1:floor(size(col,1)/length(a)):size(col,1),:);
    cs=zeros(1,size(col,1));
    cs(mod(1:length(cs),2)==1)=floor(length(cs)/2);
    col=col(cs+floor(1:.5:(size(col,1)/2+.5)),:);
end;
tpe='o^xd+<*>s.hvo^xhvd+<*>s.o^xhvd+<*>s.o^xhvd+<*>s.o^xhvd+<*>s.o^xhvd+<*>s.o^xhvd+<*>s.o^xhvd+<*>s.o^xhvd+<*>s.o^xhvd+<*>s.o^xhvd+<*>s.o^xhvd+<*>s.';
lgd=[];
hold on;
for(i=unique(numG)')
    for(j=unique(ng2)')
        pt=find(numG==i & ng2==j);
        if(length(pt)>0)
            plot(pt,x(pt),tpe(j),'color',col(i,:),'markersize',8,'linewidth',2);
        end;
    end;
end;
hold off;
xlim=([0 length(numG)+1]);
xt=(b-[0; b(1:(end-1))])/2+[0; b(1:(end-1))];
% set(gca,'fontsize',16,'XTick',xt,'XTickLabel',1:length(a),'linewidth',2,'box','on');
if(isnumeric(a))
    set(gca,'fontsize',16,'XTick',xt,'XTickLabel',num2str(a),'linewidth',2,'box','on');
else
    set(gca,'fontsize',16,'XTick',xt,'XTickLabel',char(a),'linewidth',2,'box','on');
end;
xlabel('Groups','fontsize',16);

% xticklabel_rotate();
% legend(a,'location','eastOutside');