function [priors prms] = initPrms(dat)
%UNTITLED Summary of this function goes here
%   Detailed explanation goes here

cn=find(strcmp(dat.annoHead,'Primary Protein Name'));
ptn=sort(dat.anno(:,cn));
[uPtn b c]=unique(ptn(strcmp(ptn,'-')~=1));
cnt=b-[0; b(1:(end-1))];

%%% initialize the chain
[p n]=size(dat.xpr);
uPtn(cnt<=1)=[];
cnt(cnt<=1)=[];
k=length(uPtn);
pP=zeros(p,k);
res.uPtn=uPtn;
res.cnt=cnt;

%%% factor init.
[a b c]=svd(standardize(dat.xpr,2),0);
cr=corr(dat.xpr',c(:,1:10));
% nf=max(find(sum(abs(cr)>.6)>.1*p));
pcc=.3;
% nf=max(find(sum(abs(cr)>pcc)>.25*p));
nf=1;

cr=cr(:,1:nf);
f=(sqrt(n)*c(:,1:nf)./repmat(sum(c(:,1:nf).^2,1),n,1))';
z=dat.xpr;
delta=1*(abs(cr)>pcc);
%%% variable selection on errors
pPF=repmat(sum(delta)/p,p,1);
% %%% Gaussian on errors
% pPF=repmat(1,p,1);

mu=mean(dat.xpr,2);
for(i=1:p)
    coef=regress(dat.xpr(i,:)',[ones(n,1) f']);
    mu(i)=coef(1);
    delta(i,:)=delta(i,:).*coef(2:end)';
    z(i,:)=z(i,:)-delta(i,:)*f;
end;
% f=zeros(nf,n);

mem=zeros(p,1);
lambda=zeros(length(uPtn),n);
beta=std(z-repmat(mu,1,n),[],2);
% phi=1./var(dat.xpr,[],2);
phi=ones(p,1);
pVMean=100;
pMMean=8;
%%% standard deviation around .3 -> precision around 11
%%% alpha, beta > 0 to push precision away from 0.
pPhiA=1.1;
pPhiB=.001;
memProb=zeros(size(pP));
dpAlpha=.01;

for(i=1:length(uPtn))
    kp=strcmp(dat.anno(:,cn),uPtn(i));
    pP(kp,i)=100;
end;
for(i=1:p)
    if(length(find(strcmp(dat.anno(i,cn),uPtn)))>0)
        mem(i)=find(strcmp(dat.anno(i,cn),uPtn));
    end;
end;
for(i=1:size(lambda,1))
    [a b c]=svd(standardize(z(mem==i,:),2));
    lambda(i,:)=sqrt(n)*c(:,1)/sum(c(:,1).^2);
end;

prms.uPtn=uPtn;
prms.lambda=lambda;
prms.beta=beta;
prms.phi=phi;
prms.memProb=memProb;
prms.mu=mu;
prms.delta=delta;
prms.f=f;
prms.mem=mem;
priors.pP=pP;
prms.pPF=pPF;
priors.pPhiA=pPhiA;
priors.pPhiB=pPhiB;
priors.dpAlpha=dpAlpha;
priors.pVMean=pVMean;
priors.pMMean=pMMean;

end

