function [ ll ] = maximizeProteomics( dat, prms, priors, iter, pth )
%MAXIMIZEPROTEOMICS Summary of this function goes here
%   Detailed explanation goes here
[p n]=size(dat.xpr);
k=size(prms.lambda,1);
nf=size(prms.f,1);

uPtn=prms.uPtn;
cnt=prms.cnt;
lambda=prms.lambda;
beta=prms.beta;
phi=prms.phi;
memProb=prms.memProb;
mem=prms.mem;
mu=prms.mu;
delta=prms.delta;
f=prms.f;

pPhiA=priors.pPhiA;
pPhiB=priors.pPhiB;
pP=priors.pP;
pPF=priors.pPF;
dpAlpha=priors.dpAlpha;
pVMean=priors.pVMean;
pMMean=priors.pMMean;

nSteps=10;
llold=2e10;
ll=1e10;
% for(mc=1:nSteps)
while (llold-ll>1e-4*llold)
    %%% update error factors
    z=dat.xpr-repmat(mu,1,n)-repmat(beta,1,n).*lambda(mem,:);
    for(i=1:nf)
        zchk=z-delta(:,[1:(i-1) (i+1):nf])*f([1:(i-1) (i+1):nf],:);
        kp=find(delta(:,i)~=0);
        f(i,:)=uMvn1(zchk(kp,:),phi(kp),f(i,:),pPhiA,pPhiB,1);
    end; 

    %%% update error factor loadings
    for(i=1:nf)
        zchk=z-delta(:,[1:(i-1) (i+1):nf])*f([1:(i-1) (i+1):nf],:);
        delta(:,i)=updateDelta( zchk,phi,pPF(:,i),f(i,:),1);
        pPF(:,i)=(sum(delta(:,i)~=0)+1)./(sum(delta(:,i)~=0)+1+sum(delta(:,i)==0)+1);
    end;    
    
    %%% update atom locations
    z=dat.xpr-repmat(mu,1,n)-delta*f;
    for(i=1:length(uPtn))
        kp=find(mem==i);
        lambda(i,:)=uMvn1(z(kp,:),phi(kp),lambda(i,:),pPhiA,pPhiB,1);
    end;
    
    %%% update membership probabilities and membership id's
    %%% z is still defined from previous step
    %%% update pP with number of observations in each group, dirichlet
    %%% prior
%     memProbDP=uDPMem(z,mem,pP,phi);
    counts=hist(mem(mem~=0),k);
    pp=pP+repmat(counts,p,1)+dpAlpha;
    memProb=uMvtMem1(z,lambda,pp,pPhiA,pPhiB);   
    [jnk mem]=max(memProb,[],2);    
    
    %%% update sigma and beta
    %%% z is still defined from earlier step
    for(i=1:length(uPtn))
        kp=find(mem==i);
        [beta(kp) phi(kp)]=uMvn2(z(kp,:),lambda(i,:),pPhiA,pPhiB,1);
    end;    
    
    %%% update mu
    for(i=1:length(uPtn))
        kp=find(mem==i);
        z=dat.xpr(kp,:)-beta(kp)*lambda(i,:)-delta(kp,:)*f;
        s2=1./(1/pVMean+n*phi(kp));
        mu(kp)=s2.*((1/pVMean)*pMMean+(n*phi(kp)).*mean(z,2));
    end;
    llold=ll;
    resid=dat.xpr-repmat(mu,1,n)-repmat(beta,1,n).*lambda(mem,:)-delta*f;
    nm=0; for(i=1:p) nm=nm+normlike([0 1/sqrt(phi(i))],resid(i,:)); end;
    gpr=0; for(i=1:p) gpr=gpr-log((dpAlpha+pP(i,mem(i)))/(k*dpAlpha+sum(pP(i,:)))); end;
    fpr=0; for(j=1:nf) fpr=fpr-sum(log(1-pPF(delta(:,j)==0)))-sum(log((pPF(delta(:,j)~=0)).*normpdf(delta(delta(:,j)~=0,j),0,1/sqrt(.01)))); end;
    phill=gamlike([pPhiA 1/pPhiB],phi);
    ll=nm+phill+gpr+fpr+normlike([0 10],mu);
    ll
end;


prms.uPtn=uPtn;
prms.cnt=cnt;
prms.lambda=lambda;
prms.beta=beta;
prms.phi=phi;
prms.memProb=memProb;
prms.mu=mu;
prms.delta=delta;
prms.f=f;
prms.mem=mem;
prms.ll=ll;
save([pth '\data' num2str(iter) '-' num2str(ll,7)],'prms','dat');

end

