function [ nm, cov, sig ] = plotProtein( pp,pt,subset )
%UNTITLED2 plots a protein with the elements in pp labeled in black and the
%subset of those elements identified in subset labeled in red.

if(~all(subset==0 | subset==1))
    'Converting subset into an indicator variable'
    ind=zeros(length(pp),1);
    ind(subset)=1;
    subset=ind;
end;

% db=scanfile('D:\dataRepository\tissueSamples\serum\darpaFlu\proteinSequences.txt',50000);
fid=fopen('D:\utilities\proteomics\proteinSequences.txt');
db=textscan(fid,'%s %s %s %s %s %s %s','BufSize',50000);
fclose(fid);
ptnSeq=[db{1} db{4}];
ptnSeq=upper(ptnSeq);
pp=upper(pp);
pt=upper(pt);
drp=find(strcmp(pp,'-'));
pp(drp)=[];
pt(drp)=[];
subset(drp)=[];
['Dropped ' num2str(length(drp)) ' peptides because they are unidentified.']
k=length(pp);

flg=zeros(k,1);
for(i=1:k)
    tmp=char(pp(i));
    drp=find(tmp<'A' | tmp>'Z');
    tmp(drp)=[];
    pp(i)=cellstr(tmp);
    if(length(drp)>0) flg(i)=1; end;
end;

[pt ord]=sort(pt);
pp=pp(ord);
flg=flg(ord);
subset=subset(ord);
upt=unique(pt(find(subset)));

[a b c]=intersect(upt,ptnSeq(:,1));
ptnSeq=ptnSeq(c,:);

so=zeros(length(upt),2);
for(i=1:length(upt)) 
    kp=find(strcmp(pt,ptnSeq(i,1)));
    so(i,1)=sum(subset(kp))/sum(subset);
    so(i,2)=sum(subset(kp))/length(kp);
end;
[jnk ord]=sortrows(so);
ptnSeq=ptnSeq(ord,:);
upt=upt(ord);
cov=[];
sig=[];
clf;
hold on;
xlim([-.1 1.75]);
ylim([0 length(upt)+1.5]);
text(.9,length(upt)+1,'% Coverage','fontsize',16)
text(1.35,length(upt)+1,'% Signature','fontsize',16)
for(i=1:length(upt))
    kp=find(strcmp(pt,ptnSeq(i,1)));
    [jnk ord]=sort(subset(kp));
    kp=kp(ord);
    seq=char(ptnSeq(i,2));
    ln=length(seq);
    plot([0 1],[i i],'color',[.75 .75 .75],'linewidth',10);
%     plot([1 ln],[i i],'color',[.75 .75 .75],'linewidth',10);
    for(j=1:length(kp))
        mtchCnt=zeros(size(seq));
        tst=char(pp(kp(j)));
        sz=length(tst);
        for(k=1:(length(seq)-sz+1))
            mtchCnt(k)=sum(tst==seq(k:(k+sz-1)));
        end;
        mx=find(mtchCnt==max(mtchCnt));
        if(mtchCnt(mx)<sz-1)
            [tst ' is a poor match for ' char(ptnSeq(i,1))]
        end;
        if(subset(kp(j)))
            plot([mx/ln (mx+sz)/ln],[i i],'r','linewidth',10);
%             plot(mx/ln,i+.5,'vr')
        else
            plot([mx/ln (mx+sz)/ln],[i i],'k','linewidth',10);
%             plot(mx/ln,i-.5,'^k')
        end;
    end;
    cov=[cov; sum(subset(kp))/length(kp)];
    sig=[sig; sum(subset(kp))/sum(subset)];
    text(1.05,i,num2str(cov(i),2),'fontsize',16);
    text(1.4,i,num2str(sig(i),2),'fontsize',16);
    pause(.01);
end
set(gca,'fontsize',16,'YTick',1:length(upt),'YTickLabel',strtok(ptnSeq(:,1),'_'))
nm=ptnSeq(:,1);
hold off;
bkw=length(nm):-1:1;
nm=nm(bkw);
cov=cov(bkw);
sig=sig(bkw);


