function [ prms ] = proteoMCMCStep(dat, priors, prms, reset)
%PROTEOMICS 1 step in fitting the model with MCMC

if(nargin<4)
    reset=0;
end;

lambda=prms.lambda;
beta=prms.beta;
phi=prms.phi;
memProb=prms.memProb;
mu=prms.mu;
delta=prms.delta;
f=prms.f;
mem=prms.mem;

[p n]=size(dat.xpr);
nf=size(prms.f,1);
k=length(prms.uPtn);

%%% update error factors
if(size(f,1)>0)
    z=dat.xpr-repmat(mu,1,n);
    i=find(mem~=0);
    z(i,:)=z(i,:)-repmat(beta(i),1,n).*lambda(mem(i),:);
    for(i=1:nf)
        zchk=z-delta(:,[1:(i-1) (i+1):nf])*f([1:(i-1) (i+1):nf],:);
        kp=find(delta(:,i)~=0);
    %     f(i,:)=uMvn1(zchk(kp,:),phi(kp),f(i,:),priors.pPhiA,priors.pPhiB);
        if(length(kp)>0)
            [f(i,:) delta(kp,i)]=uMvn1(zchk(kp,:),phi(kp),delta(kp,i));
        end;
    end; 
end;

% %%% update error factor loadings
% for(i=1:nf)
%     zchk=z-delta(:,[1:(i-1) (i+1):nf])*f([1:(i-1) (i+1):nf],:);
%     delta(:,i)=updateDelta( zchk,phi,prms.pPF(:,i),f(i,:) );
%     prms.pPF(:,i)=betarnd(sum(delta(:,i)~=0)+1,sum(delta(:,i)==0)+1);
% end;    

%%% update error factor loadings: Gaussian prior
if(size(f,1)>0)
    for(i=1:size(dat.xpr,1))
        y=z(i,:)';
    %     kpnf=find(delta(i,:)~=0);
        kpnf=1:size(f,1);
        x=f(kpnf,:)';
        pr=x'*x*phi(i);
        cv=inv(pr);
        m=inv(eye(size(x,2))+x'*x*phi(i))*x'*y*phi(i);
        b=mvnrnd(m,cv);
        delta(i,kpnf)=b;
    end;
end;

%%% update atom locations
z=dat.xpr-repmat(mu,1,n);
if(size(f,1)>0)
    z=z-delta*f;
end;
for(i=1:k)
    kp=find(mem==i);
%     lambda(i,:)=uMvn1(z(kp,:),phi(kp),lambda(i,:),priors.pPhiA,priors.pPhiB);
    if(length(kp)>0)
        [lambda(i,:) beta(kp)]=uMvn1(z(kp,:),phi(kp),beta(kp));
    else
        lambda(i,:)=normrnd(0,1,1,n);
        l=sqrt(sum(lambda(i,:).^2));
        lambda(i,:)=lambda(i,:)*sqrt(n)/l;
    end;
end;


%%% update membership probabilities and membership id's
%%% z is still defined from previous step
%%% update priors.pP with number of observations in each group, dirichlet
%%% prior
%     memProbDP=uDPMem(z,mem,priors.pP,phi);
counts=hist(mem(mem~=0),k);
pp=priors.pP+repmat(counts,p,1);
memProb=uMvtMem1(z,lambda,pp,priors.pPhiA,priors.pPhiB);   
for(i=1:p)
    mem(i)=randsample(k,1,true,memProb(i,:));    
end;
%     tMem(:,mc)=mem;

%%% update sigma and beta
%%% z is still defined from earlier step
for(i=1:length(prms.uPtn))
    kp=find(mem==i);
    [beta(kp) phi(kp)]=uMvn2(z(kp,:),lambda(i,:),priors.pPhiA,priors.pPhiB);
end;    
%     tBeta(:,mc)=beta;
%     tSig(:,mc)=phi;

%%% update mu
for(i=1:length(prms.uPtn))
    kp=find(mem==i);
    z=dat.xpr(kp,:)-beta(kp)*lambda(i,:);
    if(size(f,1)>0)
        z=z-delta(kp,:)*f;
    end;
    s2=1./(1/priors.pVMean+n*phi(kp));
    m=s2.*((1/priors.pVMean)*priors.pMMean+(n*phi(kp)).*mean(z,2));
    mu(kp)=normrnd(m,sqrt(s2));
end;

%%% ensure the error factors and meta-proteins aren't colinear %%%%%%
%%% resample all of the regression coefficients.
% for(i=1:size(dat.xpr,1))
%     y=dat.xpr(i,:)'-mu(i);
%     kpnf=find(delta(i,:)~=0);
%     x=[f(kpnf,:)' lambda(mem(i),:)'];
%     pr=x'*x*phi(i);
%     cv=inv(pr);
%     m=inv(eye(size(x,2))+x'*x*phi(i))*x'*y*phi(i);
%     b=mvnrnd(m,cv);
%     beta(i)=b(end);
%     delta(i,kpnf)=b(1:(end-1));
% end;
% 
if(reset>0)
    cr=corr(f',lambda');
    redo=find(max(abs(cr),[],1)>reset);
    lambda(redo,:)=ones(size(lambda(redo,:)));
    redo=find(ismember(mem,redo));
    beta(redo)=0;
    for(i=1:length(redo))
        b=(regress(dat.xpr(redo(i),:)',[ones(size(f,2),1) f']))';
        mu(redo(i))=b(1);
        delta(redo(i),:)=b(2:end);
    end;
end;

%     z=dat.xpr(redo,:)-repmat(mu(redo),1,n);
%     for(i=1:nf)
%         zchk=z-delta(:,[1:(i-1) (i+1):nf])*f([1:(i-1) (i+1):nf],:);
%         kp=find(delta(:,i)~=0);
%     %     f(i,:)=uMvn1(zchk(kp,:),phi(kp),f(i,:),priors.pPhiA,priors.pPhiB);
%         if(length(kp)>0)
%             [f(i,:) delta(kp,i)]=uMvn1(zchk(kp,:),phi(kp),delta(kp,i));
%         end;
%     end; 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%     if(mc>nBurnin & mod(mc,1000)==0)
prms.lambda=lambda;
prms.beta=beta;
prms.phi=phi;
prms.memProb=memProb;
prms.mu=mu;
prms.delta=delta;
prms.f=f;
prms.mem=mem;
end

