function [ res ] = proteomics( dat, pth )
%PROTEOMICS Summary of this function goes here
%   Detailed explanation goes here

cn=find(strcmp(dat.annoHead,'Primary Protein Name'));
ptn=sort(dat.anno(:,cn));
[uPtn b c]=unique(ptn(strcmp(ptn,'-')~=1));
cnt=b-[0; b(1:(end-1))];

%%% initialize the chain
[p n]=size(dat.xpr);
uPtn(cnt<=1)=[];
cnt(cnt<=1)=[];
k=length(uPtn);
pP=zeros(p,k);
res.uPtn=uPtn;
res.cnt=cnt;

%%% factor init.
[a b c]=svd(standardize(dat.xpr,2),0);
cr=corr(dat.xpr',c(:,1:10));
% nf=max(find(sum(abs(cr)>.6)>.1*p));
pcc=.3;
nf=max(find(sum(abs(cr)>pcc)>.25*p));


cr=cr(:,1:nf);
f=(sqrt(n)*c(:,1:nf)./repmat(sum(c(:,1:nf).^2,1),n,1))';
z=dat.xpr;
delta=1*(abs(cr)>pcc);
pPF=repmat(sum(delta)/p,p,1);
mu=mean(dat.xpr,2);
for(i=1:p)
    coef=regress(dat.xpr(i,:)',[ones(n,1) f']);
    mu(i)=coef(1);
    delta(i,:)=delta(i,:).*coef(2:end)';
    z(i,:)=z(i,:)-delta(i,:)*f;
end;
% f=zeros(nf,n);

mem=zeros(p,1);
lambda=zeros(length(uPtn),n);
beta=std(z-repmat(mu,1,n),[],2);
% phi=1./var(dat.xpr,[],2);
phi=ones(p,1);
pVMean=100;
pMMean=8;
%%% standard deviation around .3 -> precision around 11
%%% alpha, beta > 0 to push precision away from 0.
pPhiA=1.1;
pPhiB=.001;
memProb=zeros(size(pP));
dpAlpha=.01;

for(i=1:length(uPtn))
    kp=strcmp(dat.anno(:,cn),uPtn(i));
    pP(kp,i)=100;
end;
for(i=1:p)
    if(length(find(strcmp(dat.anno(i,cn),uPtn)))>0)
        mem(i)=find(strcmp(dat.anno(i,cn),uPtn));
    end;
end;
for(i=1:size(lambda,1))
    [a b c]=svd(standardize(z(mem==i,:),2));
    lambda(i,:)=sqrt(n)*c(:,1)/sum(c(:,1).^2);
end;

%%% initialize tracking parameters
mBeta=zeros(size(beta));
mProb=zeros(size(memProb));
mPhi=zeros(size(phi));
mLambda=zeros(size(lambda));
mMu=zeros(size(mu));
mF=zeros(size(f));
mPDelta=zeros(size(delta));
mDelta=zeros(size(delta));
nSteps=4000;
nBurnin=400;

for(mc=1:nSteps)
    %%% update error factors
    z=dat.xpr-repmat(mu,1,n);
    i=find(mem~=0);
    z(i,:)=z(i,:)-repmat(beta(i),1,n).*lambda(mem(i),:);
    for(i=1:nf)
        zchk=z-delta(:,[1:(i-1) (i+1):nf])*f([1:(i-1) (i+1):nf],:);
        kp=find(delta(:,i)~=0);
        f(i,:)=uMvn1(zchk(kp,:),phi(kp),f(i,:),pPhiA,pPhiB);
    end; 

    %%% update error factor loadings
    for(i=1:nf)
        zchk=z-delta(:,[1:(i-1) (i+1):nf])*f([1:(i-1) (i+1):nf],:);
        delta(:,i)=updateDelta( zchk,phi,pPF(:,i),f(i,:) );
        pPF(:,i)=betarnd(sum(delta(:,i)~=0)+1,sum(delta(:,i)==0)+1);
    end;    
    
    %%% update atom locations
    z=dat.xpr-repmat(mu,1,n)-delta*f;
    for(i=1:length(uPtn))
        kp=find(mem==i);
        lambda(i,:)=uMvn1(z(kp,:),phi(kp),lambda(i,:),pPhiA,pPhiB);
    end;
    
    %%% update membership probabilities and membership id's
    %%% z is still defined from previous step
    %%% update pP with number of observations in each group, dirichlet
    %%% prior
%     memProbDP=uDPMem(z,mem,pP,phi);
    counts=hist(mem(mem~=0),k);
    pp=pP+repmat(counts,p,1)+dpAlpha;
    memProb=uMvtMem1(z,lambda,pp,pPhiA,pPhiB);   
    for(i=1:p)
        mem(i)=randsample(k,1,true,memProb(i,:));    
    end;
%     tMem(:,mc)=mem;
    
    %%% update sigma and beta
    %%% z is still defined from earlier step
    for(i=1:length(uPtn))
        kp=find(mem==i);
        [beta(kp) phi(kp)]=uMvn2(z(kp,:),lambda(i,:),pPhiA,pPhiB);
    end;    
%     tBeta(:,mc)=beta;
%     tSig(:,mc)=phi;
    
    %%% update mu
    for(i=1:length(uPtn))
        kp=find(mem==i);
        z=dat.xpr(kp,:)-beta(kp)*lambda(i,:)-delta(kp,:)*f;
        s2=1./(1/pVMean+n*phi(kp));
        m=s2.*((1/pVMean)*pMMean+(n*phi(kp)).*mean(z,2));
        mu(kp)=normrnd(m,sqrt(s2));
    end;
%     resid=dat.xpr-repmat(mu,1,n)-repmat(beta,1,n).*lambda(mem,:)-delta*f;
%     nm=0; for(i=1:p) nm=nm+normlike([0 1/sqrt(phi(i))],resid(i,:)); end;
%     gpr=0; for(i=1:p) gpr=gpr-log((dpAlpha+pP(i,mem(i)))/(k*dpAlpha+sum(pP(i,:)))); end;
%     fpr=0; for(j=1:nf) fpr=fpr-sum(log(1-pPF(delta(:,j)==0)))-sum(log((pPF(delta(:,j)~=0)).*normpdf(delta(delta(:,j)~=0,j),0,1/sqrt(.01)))); end;
%     figure(1); hold on; plot(mc,nm,'.'); hold off; title('Normality');
%     figure(2); phill=gamlike([pPhiA 1/pPhiB],phi); hold on; plot(mc,phill,'.'); hold off; title('Phi');
%     figure(3); hold on; plot(mc,gpr,'.'); hold off; title('Membership Probability');
%     figure(4); hold on; plot(mc,fpr,'.'); hold off; title('Regression Coefficients, fac1');
%     figure(5); hold on; plot(mc,normlike([0 10],mu),'.'); hold off; title('Means');
%     figure(6); hold on; plot(mc,pPF(1,:),'.'); hold off; title('Prob Zero, fac1');
%     figure(7); hold on; plot(mc,nm+phill+gpr+fpr+normlike([0 10],mu),'.'); hold off; title('Likelihood');
%     figure(8);
%     hist(log(gampdf(phi,pPhiA,1/pPhiB)),100);
%     figure(9)
%     [a b]=hist(beta.*sqrt(phi),100);
%     plot(b,a/sum(a));
%     pause(.01);
    if(mod(mc,50)==0)
        mc
    end;
%     if(mc>nBurnin & mod(mc,1000)==0)
        prms.uPtn=uPtn;
        prms.cnt=cnt;
        prms.lambda=lambda;
        prms.beta=beta;
        prms.phi=phi;
        prms.memProb=memProb;
        prms.mu=mu;
        prms.delta=delta;
        prms.f=f;
        prms.mem=mem;
        priors.pP=pP;
        priors.pPF=pPF;
        priors.pPhiA=pPhiA;
        priors.pPhiB=pPhiB;
        priors.dpAlpha=dpAlpha;
        priors.pVMean=pVMean;
        priors.pMMean=pMMean;
        maximizeProteomics(dat, prms, priors, mc, pth);
%         printResults(dat,at, 'responderReclassified',prms,mc);
%     end;
    if(mc>nBurnin)
        mBeta=mBeta+beta;
        mProb=mProb+memProb;
        mPhi=mPhi+phi;
        mLambda=mLambda+lambda;
        mMu=mMu+mu;
        mDelta=mDelta+delta;
        mF=mF+f;
        mPDelta=mPDelta+1*(delta~=0);
    end;
end;
res.mBeta=mBeta/(nSteps-nBurnin);
res.mProb=mProb/(nSteps-nBurnin);
res.mPhi=mPhi/(nSteps-nBurnin);
res.mLambda=mLambda/(nSteps-nBurnin);
res.mMu=mMu/(nSteps-nBurnin);
res.mDelta=mDelta/(nSteps-nBurnin);
res.mF=mF/(nSteps-nBurnin);
res.mPDelta=mPDelta/(nSteps-nBurnin);
end

