function [ pMu kSig prob ] = selapMixMap( dat,ss, S )
% accepts a data set, dat, which consists of an NxP matrix where N is the
% number of observations from a space of dimension P.  These are assumed to
% originate from a mixture of normal distributions.  The number and prior
% means for the distributions are computed by affinity propogation.  Return
% values are: mem - NxK matrix of membership probabilities for each
% observation and each element in the mixture, mu - PxK dimensional matrix
% containing the posterior mean for the location of each of the K elements in the mixture, sigma -
% (PxP)xK matrix of covariance matricies.  Each column contains the
% elements in the covariance matrix for its corresponding mixture element.

[N P]=size(dat);
if(nargin<3)
    'Calculating similarities matrix.'
    S=zeros(N,N);
    for(i=1:N)
        for(j=1:N)
            S(i,j)=-sqrt(sum((dat(i,:)-dat(j,:)).^2));
        end;
    end;
end;

if(nargin==1)
    ss=median(S(:));
end;

'Computing affinity propogation clusters.'
idx=affProp(S,ss,.9);

['There are ' num2str(length(unique(idx))) ' groups.']

seeds=unique(idx);
K=length(seeds);
dm=size(dat,2);

%%% hyper-parameters
df=P+1;
kappa=.01;
priorProb=ones(1,K);
prob=priorProb/sum(priorProb);

%%% initialize
priorBg=.01;
pMu=zeros(size(dat(seeds,:)'));
sigma=eye(dm);
pSigma=zeros(dm^2,K);
for(i=1:K)
    pSigma(:,i)=sigma(:);
end;
pMu=dat(seeds,:)';
% for(i=1:length(seeds))
%     pMu(:,i)=mean(dat(idx==seeds(i),:))';
%     tmp=cov(dat(idx==seeds(i),:));
%     pSigma(:,i)=tmp(:);
% end;
priorMu=pMu;
kSig=pSigma;
mem=zeros(size(idx));
for(i=1:length(seeds))
    mem(idx==seeds(i))=i;
end;

'Fitting mixture distribution.'
iter=1000;
burnin=100;
sig=zeros(size(kSig));
vdf=zeros(K,1);
llTrace=0;
for(i=1:iter)
    for(j=1:K)
        prob(j)=priorProb(j)+sum(mem==j);
    end;
    prob=prob/sum(prob);
    for(j=1:K)
        jdx=find(mem==j);
        nj=length(jdx);
        if(nj>0)
            z=dat(jdx,:)';
            mz=mean(z,2);
            z=z-repmat(mz,1,nj);
        end;
        sigma(:)=pSigma(:,j);
        if(nj>0)
            sigma=sigma+z*z'+kappa*nj/(kappa+nj)*(mz-priorMu(:,j))*(mz-priorMu(:,j))';
        end;
        sigma=sigma*(kappa+nj+1)/((kappa+nj)*(df+nj-P+1));
        vdf(j)=df+nj-P+1;
        kSig(:,j)=sigma(:);

        pMu(:,j)=kappa/(kappa+nj)*priorMu(:,j);
        if(nj>0)
            pMu(:,j)=pMu(:,j)+nj/(kappa+nj)*mz;
        end;
        
        sig(:,j)=sigma(:);   %%% only used for plotting
    end;
    [jnk mem]=max(mvtMixtureProb(pMu,kSig,vdf, prob, dat'),[],2);
    if(mod(i,100)==0)
        [num2str(i) '/' num2str(iter)]
    end;
%     %%% plotting
%     if(mod(i,50)==0)
%         col=colormap();
%         col=col(1:floor(size(col,1)/K:size(col,1),:);
%         for(jnk=1:(size(dat,2)/2))
%             figure(jnk);
% %             clf('reset');
%             clf;
%             hold on;
%             tmp=zeros(size(sigma));
%             for(cnt=1:max(mem))
%                 plot(dat(find(mem==cnt),2*jnk-1),dat(find(mem==cnt),2*jnk),'.','color',col(cnt,:));
%                 tmp(:)=sig(:,cnt);
%                 plotMVN(pMu([2*jnk-1 2*jnk],cnt),tmp([2*jnk-1 2*jnk],[2*jnk-1 2*jnk]),col(cnt,:));
%             end;
%             hold off;
%         end;
%         pause(.01);
%     end;
%     %%%%%%%%%%%%%
    llTraceNew=mvnMixtureLogLikelihood(dat,pMu,kSig,prob);
    if(abs(llTrace-llTraceNew)<1e-5)
        return;
    else
        llTrace=llTraceNew;
    end;
end;


