
% create upper triangular array of pairwise variable inclusion probabilities 
%  conditional on top k models out of nm
% Result is in (symmetric) matrix ppw

pmk=pm/sum(pm(1:k));            % condition on only the top k models chosen
ppw=zeros(N,N); 
for j=1:k
      p=models(j,1);                             % dim of this model
      ig=models(j,2+(1:p));                      % (ordered names of) predictors in model    
       lig = length(ig);
       for i=1:lig
         ppw(ig(i),ig(i:lig)) = ppw(ig(i),ig(i:lig))+pmk(j);
       end 
end
clear i
% symmetrize ... 
ppw=ppw+ppw'-diag(diag(ppw)); 

ig=find(sum(ppw~=0)); ppw=ppw(ig,ig); nig=length(ig); del=nig/12; 
imagesc(ppw); title('Pairwise variable inclusion probs'); axis off
text((1:nig)',ones(nig,1)*(nig+del),int2str(ig'),'horizontalalignment','center')
text(ones(nig,1)*(1-del),(1:nig)',int2str(ig'),'horizontalalignment','right')
cmap('hot'); colorbar
[ int2str((ig)') repmat('   ',nig,1) num2str(pmp(ig),2) repmat('  ',nig,1) Des(ig,:) ]
[ char(Des) repmat('  ',N,1) num2str(ppw,2) ]