function [ mFit vList ] = sss( y,x,w, deltaVar, val )
%SSS Summary of this function goes here
%   Detailed explanation goes here

if(nargin<4)
    deltaVar=[];
    val=[];
end;

useless=[];
for(i=1:size(x,2))
    if(all(x(:,i)==x(1,i)))
        useless=[useless i];
        ['Predictor ' num2str(i) ' is constant and will be dropped.']
    end;
end;
useful=1:size(x,2);
useful(useless)=[];
x(:,useless)=[];

% drp=find(sum(x==1)==size(x,1));
% if(length(drp)>0)
%     'Including a column of ones in x is unnecessary. It is  being dropped.'
%     x(:,drp)=[];
% end;

if(nargin<3)
    w=ones(size(y,1),1);
end;

itrain=(1:length(w));
ivalid=find(w==0);
itrain(ivalid)=[];

drp=find(sum(isnan([y x]),2)>0);
if(length(drp)>0)
    'Some predictors or outcomes are NaN.  Setting the weights of these observations to zero.'
    w(drp)=0;
    nanx=isnan(x);
    x(isnan(x))=0;
    nany=isnan(y);
    y(isnan(y))=1;
else
    nanx=[];
    nany=[];
end;

% cdir=pwd();

%%% add test here to make sure that r and y are right.
if(size(y,2)>2)
    'y should have one column for binary or linear regression or two columns for survival models.'
    return;
end;
if(size(y,2)==2)
    r=y(:,2);
    y=y(:,1); 
    'y has two columns, assuming survival model'
end;    

lines=[];
variables=[
    {'NOBSERVATIONS'};
    {'NVARIABLES'};
    {'DATAFILE'};
    {'OUTFILE'};
    {'RESPONSEFILE'};
    {'WEIGHTSFILE'};
    {'ITEROUT'};
    {'SUMMARYFILE'};
    {'CENSORFILE'};
    {'NOISY'};
    {'NORMSTAND'};
    {'DSTART'};
    {'ONEVAR'};
    {'modtype'};
    {'iters'};
    {'NBest'};
    {'kmax'};
    {'innerAnneal1'};
    {'innerAnneal2'};
    {'innerAnneal3'};
    {'outerAnneal'};
    {'penalty'}
    ];

defaults=[
    {''};
    {''};
    {'data.txt'};
    {'models.txt'};
    {'responses.txt'};
    {'weights.txt'};
    {'iterout.txt'};
    {'modelsummary.txt'};
    {'NA'};
    {'1'};
    {'1'};
    {'2'};
    {'1'};
    {'1'};
    {'1000'};
    {'1000'};
    {''};
    {'0.6'};
    {'0.8'};
    {'1'};
    {'0.4'};
    {'1'}
    ];

if(exist('r'))    
    defaults(strcmp(variables,'CENSORFILE'))={'r.txt'};
    defaults(strcmp(variables,'modtype'))=cellstr('3');
elseif(all(y==0 | y==1))
    'All values in y are either 0, 1 or NaN. Assuming binary regression.'
    defaults(strcmp(variables,'modtype'))=cellstr('2');
end;    

defaults(strcmp(variables,'NOBSERVATIONS'))=cellstr(num2str(size(y,1)));
defaults(strcmp(variables,'NVARIABLES'))=cellstr(num2str(size(x,2)));
defaults(strcmp(variables,'kmax'))=cellstr(num2str(size(x,2)));

% if(exist('data.txt','file') | 
%     exist('models.txt','file') |
%     exist('responses.txt','file') |
%     exist('weights.txt','file') |
%     exist('iterout.txt','file') |
%     exist('modelsummary.txt','file') |
%     exist('sss.config.txt','file'))
%     'Some files in this directory will be overwritten. Ctrl-c to cancel.'
%     pause;
% end;

for(i=1:length(deltaVar))
    defaults(strcmp(variables,deltaVar(i)))=val(i);
end;

lines=cell(size(variables));
for(i=1:length(variables))
    lines(i)=cellstr([char(variables(i)) ' = ' char(defaults(i))]);
end;

% cd d:\sss;
copyfile('d:\sss\modelsearch.exe','.');
copyfile('d:\sss\modelsummary.exe','.');

dlmwrite(char(defaults(strcmp(variables,'DATAFILE'))), num2str(x,10),'newline','pc','delimiter','');
dlmwrite(char(defaults(strcmp(variables,'RESPONSEFILE'))), num2str(y,10),'newline','pc','delimiter','');
dlmwrite(char(defaults(strcmp(variables,'WEIGHTSFILE'))), num2str(w,3),'newline','pc','delimiter','');
if(exist('r'))
    dlmwrite(char(defaults(strcmp(variables,'CENSORFILE'))), num2str(r,1),'newline','pc','delimiter','');
end;
dlmwrite('sss.config.txt',char(lines),'newline','pc','delimiter','');
!modelsearch sss.config.txt

x(nanx)=NaN;
y(nany)=NaN;

[n N]=size(x);
models=scanData(char(defaults(strcmp(variables,'SUMMARYFILE'))));
nm=size(models,1); pm=models(:,2);pm=exp(pm-max(pm));pm=pm/sum(pm);pmax=max(models(:,1)); 
k=min(c2n(defaults(strcmp(variables,'NBest'))),size(models,1));

if(c2n(defaults(strcmp(variables,'modtype')))==1)
    linfitpredict;
    mFit=aveFit;
elseif(c2n(defaults(strcmp(variables,'modtype')))==2)
    binaryfitpredict;
    mFit=avepFit;
elseif(c2n(defaults(strcmp(variables,'modtype')))==3)
    survivalsummary;
    mFit=aveFit;
end;

% cd(cdir);
end

