function [p] = survivalQuantile( scr, time, ind, q )
%MAXDISCRIM Summary of this function goes here
%   Detailed explanation goes here
if(nargin<4)
    q=50;
end;
time(time==0)=.01;
kp=find(time>0 & ind>=0 & ~isnan(scr));
time=time(kp);
ind=ind(kp);
scr=scr(kp);

fontsize=16;

if(length(unique(scr))==1)
    kmgroup(time,ind,scr,1);
    p=[];
elseif(length(unique(scr))<4)
    cat=unique(scr);
    catVar=[];
    pctg=zeros(size(cat));
    for(cnt=1:length(cat))
        catVar=[catVar scr==cat(cnt)];
        pctg(cnt)=sum(scr==cat(cnt));
    end;
    pctg=tril(ones(length(cat),length(cat)))*pctg * 100/length(scr);
    pctg=pctg(1:(end-1));
    [b,logl,fred,stats]=coxphfit(catVar(:,1:(end-1)),time,'censoring',1-ind);
    p=stats.p;
    kmgroup(time, ind, scr,pctg)
    legend(num2str(cat));
else
%     [b,logl,fred,stats]=coxphfit(scr>=median(scr),time,'censoring',1-ind);
    if(max(scr)==median(scr))
        brk=(sum(scr<max(scr))*100-50)/length(scr);
    else
        brk=q;
    end;
    [b,logl,fred,stats]=coxphfit(scr,time,'censoring',1-ind);
    p=stats.p;
    kmgroup(time, ind, scr,[brk])
    legend('Low Signature','High Signature','location','southwest')
end;
set(gca,'fontsize',fontsize);
xlabel('Time','fontsize',fontsize);
ylabel('Survival','fontsize',fontsize);
xlim([0 max(time(ind==1))*1.05]);
title('');
if(length(p)==1)
    text(1,.4,['p=' num2str(p)],'fontsize',fontsize);
end;

