function [ra rb d] = vennDiagram( a,b,ab)
%VENNDIAGRAM Summary of this function goes here
%   Detailed explanation goes here
mx=max([a,b,ab]);
a=a/mx;
b=b/mx;
ab=ab/mx;

ra=sqrt(a/3.1415);
rb=sqrt(b/3.1415);

x=[(-1:.01:1)*ra;(-1:.01:1)*rb];
y=sqrt(repmat([ra;rb].^2,1,201)-x.^2);

dab=findCircDist(ra,rb,ab);
cent=[0,0;dab,0];


d=norm(cent(1,:)-cent(2,:));
area=circIntArea(d(1),ra,rb)

clf;
hold on;
for(i=1:2)
    plot(x(i,:)+cent(i,1),y(i,:)+cent(i,2),'linewidth',2)
    plot(x(i,:)+cent(i,1),-y(i,:)+cent(i,2),'linewidth',2)
end;
set(gca,'XTick',[],'YTick',[]);
box on;
hold off;

