function varargout = binreg(varargin)
% BINREG M-file for binreg.fig
%      BINREG, by itself, creates a new BINREG or raises the existing
%      singleton*.
%
%      H = BINREG returns the handle to a new BINREG or the handle to
%      the existing singleton*.
%
%      BINREG('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in BINREG.M with the given input arguments.
%
%      BINREG('Property','Value',...) creates a new BINREG or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before binreg_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to binreg_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help binreg

% Last Modified by GUIDE v2.5 11-Jun-2007 16:36:30

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @binreg_OpeningFcn, ...
                   'gui_OutputFcn',  @binreg_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before binreg is made visible.
function binreg_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to binreg (see VARARGIN)

    load 'preference.mat';
    handles.UserOptions = UserOptions;
    handles.UseSavedOption = true;
    set(handles.ExcelEdit, 'String', handles.UserOptions.excel);
%    set(handles.DescEdit, 'String', handles.UserOptions.descFile);
    set(handles.GeneEdit, 'String', handles.UserOptions.genes);
    set(handles.MetageneEdit, 'String', handles.UserOptions.metagenes);
    set(handles.BurninEdit, 'String', handles.UserOptions.burnin);
    set(handles.IterationEdit, 'String', handles.UserOptions.iteration);
    set(handles.SkipsEdit, 'String', handles.UserOptions.skips);
    set(handles.CIEdit, 'String', handles.UserOptions.CI);
    set(handles.DataLogged1Check, 'Value', handles.UserOptions.datalogged1);
    set(handles.DataLogged2Check, 'Value', handles.UserOptions.datalogged2);
    set(handles.Version1Check, 'Value', handles.UserOptions.version1);
    set(handles.Version2Check, 'Value', handles.UserOptions.version2);
    set(handles.Normalization1Check, 'Value', handles.UserOptions.normalization1);
    set(handles.Normalization2Check, 'Value', handles.UserOptions.normalization2);
    set(handles.CrossVaidationCheck, 'Value', handles.UserOptions.crossvalidation);
    set(handles.PlotsCheck, 'Value', handles.UserOptions.plots);
   
% Choose default command line output for binreg
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes binreg wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = binreg_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;




%%%%% Consolidated Hints -- BB0607
% hObject    handle to ExcelEdit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.

% handles    structure with handles and user data (see GUIDATA)
% Hints: get(hObject,'String') returns contents of ExcelEdit as text
%        str2double(get(hObject,'String')) returns contents of ExcelEdit as a double

%%%%%

% --- Executes during object creation, after setting all properties.
function ExcelEdit_CreateFcn(hObject, eventdata, handles)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

% --- Executes during object creation, after setting all properties.
function ExcelEdit_Callback(hObject, eventdata, handles)
handles.UserOptions.excel = get(hObject, 'String');
if (exist(handles.UserOptions.excel) == 0)
    msgbox 'File does not exist';
    set(hObject, 'String', '');
end


% --- Executes on button press in ExcelButton.
function ExcelButton_Callback(hObject, eventdata, handles)
[ExcelFileName, ExcelFileDir]=uigetfile ...
    ('*.xls','Load in the gene Excel data file');
handles.UserOptions.excel=strcat (ExcelFileDir, ExcelFileName);
set(handles.ExcelEdit, 'String', handles.UserOptions.excel);

% --- Executes during object creation, after setting all properties.
%function DescEdit_CreateFcn(hObject, eventdata, handles)
%if ispc
%    set(hObject,'BackgroundColor','white');
%else
%    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
%end

%function DescEdit_Callback(hObject, eventdata, handles)
%handles.UserOptions.descFile = get(hObject, 'String')
%if (exist(handles.UserOptions.descFile) == 0)
%    msgbox 'File does not exist';
%    set(hObject, 'String', '');
%end

% --- Executes on button press in DescButton.
%function DescButton_Callback(hObject, eventdata, handles)
%[descFileName, descFileDir]=uigetfile ...
%    ('*.txt','Load in the gene descriptor file for microarray used');
    %create the complete path for the file
%handles.UserOptions.descFile=strcat (descFileDir, descFileName);
%set(handles.DescEdit, 'String', handles.UserOptions.descFile);


% --- Executes during object creation, after setting all properties.
function GeneEdit_CreateFcn(hObject, eventdata, handles)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function GeneEdit_Callback(hObject, eventdata, handles)
handles.UserOptions.genes = str2double(get(hObject, 'String'));


% --- Executes during object creation, after setting all properties.
function MetageneEdit_CreateFcn(hObject, eventdata, handles)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function MetageneEdit_Callback(hObject, eventdata, handles)
handles.UserOptions.metagenes = str2double(get(hObject, 'String'));


% --- Executes during object creation, after setting all properties.
function BurninEdit_CreateFcn(hObject, eventdata, handles)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function BurninEdit_Callback(hObject, eventdata, handles)
handles.UserOptions.burnin = str2double(get(hObject, 'String'));


% --- Executes during object creation, after setting all properties.
function IterationEdit_CreateFcn(hObject, eventdata, handles)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function IterationEdit_Callback(hObject, eventdata, handles)
handles.UserOptions.iteration = str2double(get(hObject, 'String'));


% --- Executes during object creation, after setting all properties.
function SkipsEdit_CreateFcn(hObject, eventdata, handles)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function SkipsEdit_Callback(hObject, eventdata, handles)
handles.UserOptions.skips = str2double(get(hObject, 'String'));


% --- Executes during object creation, after setting all properties.
function CIEdit_CreateFcn(hObject, eventdata, handles)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function CIEdit_Callback(hObject, eventdata, handles)
handles.UserOptions.CI = str2double(get(hObject, 'String'));


% --- Executes on button press in DataLogged1Check.
function DataLogged1Check_Callback(hObject, eventdata, handles)
handles.UserOptions.datalogged1 = get(hObject, 'Value');

% --- Executes on button press in DataLogged2Check.
function DataLogged2Check_Callback(hObject, eventdata, handles)
handles.UserOptions.datalogged2 = get(hObject, 'Value');


% --- Executes on button press in Normalization1Check.
function Normalization1Check_Callback(hObject, eventdata, handles)
handles.UserOptions.normalization1 = get(hObject, 'Value');

% --- Executes on button press in Normalization2Check.
function Normalization2Check_Callback(hObject, eventdata, handles)
handles.UserOptions.normalization2 = get(hObject, 'Value');

% --- Executes on button press in Version1Check.
function Version1Check_Callback(hObject, eventdata, handles)
handles.UserOptions.version1 = get(hObject, 'Value');

% --- Executes on button press in Version2Check.
function Version2Check_Callback(hObject, eventdata, handles)
handles.UserOptions.version2 = get(hObject, 'Value');

% --- Executes on button press in CrossVaidationCheck.
function CrossVaidationCheck_Callback(hObject, eventdata, handles)
handles.UserOptions.crossvalidation = get(hObject, 'Value');

% --- Executes on button press in PlotsCheck.
function PlotsCheck_Callback(hObject, eventdata, handles)
handles.UserOptions.plots = get(hObject, 'Value');

% --- Executes on button press in RunButton.
function RunButton_Callback(hObject, eventdata, handles)

handles.UserOptions.excel = get(handles.ExcelEdit, 'String');
%handles.UserOptions.descFile = get(handles.DescEdit, 'String');
handles.UserOptions.genes = str2double(get(handles.GeneEdit, 'String'));
handles.UserOptions.metagenes = str2double(get(handles.MetageneEdit, 'String'));
handles.UserOptions.burnin = str2double(get(handles.BurninEdit, 'String'));
handles.UserOptions.iteration = str2double(get(handles.IterationEdit, 'String'));
handles.UserOptions.skips = str2double(get(handles.SkipsEdit, 'String'));
handles.UserOptions.CI = str2double(get(handles.CIEdit, 'String'));
handles.UserOptions.datalogged1 = get(handles.DataLogged1Check, 'Value');
handles.UserOptions.datalogged2 = get(handles.DataLogged2Check, 'Value');
handles.UserOptions.normalization1 = get(handles.Normalization1Check, 'Value');
handles.UserOptions.normalization2 = get(handles.Normalization2Check, 'Value');
handles.UserOptions.version1 = get(handles.Version1Check, 'Value');
handles.UserOptions.version2 = get(handles.Version2Check, 'Value');
handles.UserOptions.crossvalidation = get(handles.CrossVaidationCheck, 'Value');
handles.UserOptions.plots = get(handles.PlotsCheck, 'Value');


test = [isnan(handles.UserOptions.excel) ... %isnan(handles.UserOptions.descFile) ...
        isnan(handles.UserOptions.genes) isnan(handles.UserOptions.metagenes) ...
        isnan(handles.UserOptions.burnin) isnan(handles.UserOptions.iteration) ...
        isnan(handles.UserOptions.skips) isnan(handles.UserOptions.CI) ...
        isnan(handles.UserOptions.crossvalidation) ...
        handles.UserOptions.datalogged1+handles.UserOptions.datalogged2~=1 ...
        handles.UserOptions.version1+handles.UserOptions.version2~=1];

if any(test)
    msgbox 'User input is incomplete';
else
    close(gcf);
    UserOptions = handles.UserOptions;
    save preference.mat UserOptions;
    binreg_run(UserOptions);
end;

% --- Executes on button press in Cancel.
function Cancel_Callback(hObject, eventdata, handles)
close(gcf);


