function binreg_batch(filename)

fprintf(' BinReg started \n\n')

prefs = textread(filename, '%s', 'commentstyle','shell');
x = load(char(prefs(1)));
Descriptions = txt2mat2(char(prefs(2)));

if(length(Descriptions)~=size(x,1)-1)
  fprintf('BinReg Error:  Description file length:   %d\n', ...
	  length(Descriptions));
  fprintf(' does not match the number of genes: %d\n', ...
	    size(x,1)-1);
else

  fprintf('\n Data imported from Text:\n');
  fprintf('    %d X %d matrix of gene expression\n\n', size(x,1)-1, size(x,2));

  C_group=x(1,:); x(1,:)=[];
  ngene = str2num(char(prefs(3)));
  nmetagene = str2num(char(prefs(4)));
  nburnin =str2num(char(prefs(5))); 
  ninter = str2num(char(prefs(6)));
  nskip = str2num(char(prefs(7)));
  nci = str2num(char(prefs(8)));
  logged = str2num(char(prefs(9)));
  nrm1 =str2num(char(prefs(10))); 
  nrm2 = str2num(char(prefs(11)));
  version = str2num(char(prefs(12)));
  cv = str2num(char(prefs(13)));
  silent = 1 - str2num(char(prefs(14)));


group = C_group; group(C_group==0) = 1;

if(nci<50)
  fprintf(' WARNING: Credible Interval is less than 50 percent\n\n')
end;
nci = 100 - nci;

if (nrm1 == 1) 
  m=median(x(:,group==1),2);
  x=quantnorm(x,m); 
  fprintf(' Columns quantile normalized;')
end;
if (logged == 0) 
  x(x<2) = 2; x=log2(x);  
  fprintf(' Data logged;')
end;
if (nrm2 == 1 & sum(group==2)>0) 
  x(:,group==2) = std_rows_to_y(x(:,group==2), x(:,group==1));
  fprintf(' Rows standardized by group;')
end;
fprintf('\n\n')

dlmwrite('normalizedX.txt',x);

setseed = 123;randn('seed',setseed);rand('seed',setseed);
[beta,li,alli,XX] = Mbinregsvd(x,C_group,group, ngene,nmetagene, ... 
      [nburnin ninter nskip],cv,nci,version);

mu = beta(1); beta(1) = [];


fprintf(' Writing metagene coefficients to file\n\n')

[b,oj]=sort(-abs(beta));
 
fid = fopen('genecoefficients.txt','w');
fprintf(fid,'%10.6f\t%s\n', mu, 'Intercept');
for (i = 1: ngene)
  fprintf(fid,'%10.6f\t%s\n', beta(oj(i)), Descriptions(li(oj(i)),:));
end;
fclose(fid);
if(silent==0) 
  XX = binregplots('plotdata',XX);
end;

fprintf(' BinReg finished \n\n')
  
end;
