function run_binreg(UserOptions)

fprintf(' BinReg started \n\n')

[pathstr,name,ext,versn] = fileparts(UserOptions.excel);
if strcmp(ext,'.xls')
  [x, txt] = xlsread(UserOptions.excel);
  g1 = size(txt); g2 = size(x); 
  fprintf('\n Data imported from Excel:\n');
  fprintf('    %d X %d matrix of gene expression\n', g2(1)-1, g2(2));
  if(g1(1)>=g2(1))
    fprintf('    First column of gene information used as row labels\n\n');
    Descriptions = char(txt((g1(1)-g2(1)+2):end,1));
  else
    fprintf('    Rows are labeled sequentially\n\n');
    Descriptions = strcat('Row ',num2str((1:size(x))'));
  end;
else
  x = load(UserOptions.excel); 
  g1 = size(x);
  fprintf('\n Data imported from Text:\n');
  fprintf('    %d X %d matrix of gene expression\n', g1(1)-1, g1(2));
  fprintf('    Rows are labeled sequentially\n\n');
  Descriptions = strcat('Row ',num2str((1:size(x))'));
end;

%[pathstr,name,ext,versn] = fileparts(UserOptions.descFile);
%if strcmp(ext,'.txt')
%  txt2mat2(UserOptions.descFile);
%  UserOptions.descFile = 'descriptions.mat';
%end;
%load(UserOptions.descFile);    

%if(length(Descriptions)~=size(x,1)-1)
%  'BinReg Error: Description file length'
%  ['   ' length(Descriptions)]
%  '  does not match the number of genes'
%  ['   ' size(x,1)-1]
%else

C_group=x(1,:); x(1,:)=[];
ngene = UserOptions.genes;
nmetagene = UserOptions.metagenes;
nburnin = UserOptions.burnin;
ninter = UserOptions.iteration;
nskip = UserOptions.skips;
nci = UserOptions.CI;
cv = UserOptions.crossvalidation;
nrm1 = UserOptions.normalization1;
nrm2 = UserOptions.normalization2;
silent = 1-UserOptions.plots;
version = 2 - UserOptions.version1;
logged = UserOptions.datalogged2;


group = C_group; group(C_group==0) = 1;

if(nci<50)
  fprintf(' WARNING: Credible Interval is less than 50 percent\n\n')
end;
nci = 100 - nci;


if (nrm1 == 1) 
  m=median(x(:,group==1),2);
  x=quantnorm(x,m); 
  fprintf(' Columns quantile normalized;')
end;
if (logged == 0) 
  x(x<2) = 2; x=log2(x); 
  fprintf(' Data logged;')
end;
if (nrm2 == 1 & sum(group==2)>0) 
  x(:,group==2) = std_rows_to_y(x(:,group==2), x(:,group==1));
  fprintf(' Rows standardized by group;')
end;

fprintf('\n\n')
dlmwrite('normalizedX.txt',x);

setseed = 123;randn('seed',setseed);rand('seed',setseed);
[beta,li,alli,XX] = Mbinregsvd(x,C_group,group, ngene,nmetagene, ... 
      [nburnin ninter nskip],cv,nci,version);

fprintf(' Writing metagene coefficients to file\n\n')

mu = beta(1); beta(1) = [];
[b,oj]=sort(-abs(beta));

fid = fopen('genecoefficients.txt','w');
fprintf(fid,'%10.6f\t%s\n', mu, 'Intercept');
for (i = 1: ngene)
  fprintf(fid,'%10.6f\t%s\n', beta(oj(i)), Descriptions(li(oj(i)),:));
end;
fclose(fid);



if(silent==0)
  XX = binregplots('plotdata',XX);
end;


fprintf(' BinReg finished \n\n')

