function [XX] = binregplots(filename,XX)
imagecf(XX);
load(filename);
if (Silent.f1.use > 0) 
    [g,h]=sort(abs(Silent.f1.gamma)); h=flipud(h); 
    itrain = Silent.f1.itrain;
    figure(2); set(gca,'FontSize',12);
    if (Silent.f1.nfac>1) 
        newbcpairs(Silent.f1.F(:,itrain),Silent.f1.Z(itrain),h(1:2),itrain);   
        hold off;
    else
        i=1:Silent.f1.ntrain; f=Silent.f1.F(itrain); z=Silent.f1.Z(itrain); i=i(z==0); scatter(f(i),z(i));  hold on;
        i=1:Silent.f1.ntrain; i=i(z==1); scatter(f(i),z(i),'r');  hold off; 
    end; 
end;
if (Silent.f2.use > 0) 
    figure(3); set(gca,'FontSize',14);
    subplot(2,1,1); 
    plot(Silent.f2.gamma,'--bs','MarkerSize',6,'LineWidth',1.0); hold on; 
    title('Expression weights: MetaGenes');  xlabel('Metagene'); ylabel('gamma')
    plot([0 Silent.f2.p],[0 0],'black--','LineWidth',1); hold off
    subplot(2,1,2);
    plot(Silent.f2.beta,'LineWidth',1.0); hold on; plot([0 Silent.f2.ngene],[0 0],'black--','LineWidth',1.0); hold off
    title('Expression weights: Genes')
    xlabel('Gene');  ylabel('beta')
    hold off;  
end;
if (Silent.f3.use > 0) 
    figure(4); set(gca,'FontSize',14); 
    plot([min(Silent.f3.fit) max(Silent.f3.fit)],[.5 .5],'black--','LineWidth',1); hold on;
    z=1:Silent.f3.n; z(Silent.f3.ivalid)=[]; ZZ=Silent.f3.Z; ZZ(Silent.f3.ivalid)=[]; z0=z(ZZ==0); z1=z(ZZ==1); 
    for j=z1
    text(Silent.f3.fit(j),Silent.f3.pfit(j),int2str(j),'Color','r','HorizontalAlignment','Center','FontSize',14)
    %  text(fit(j),pnorm(fit(j),0,1),int2str(j),'Color','r','HorizontalAlignment','Center')
    plot([Silent.f3.fit(j),Silent.f3.fit(j)],[max(0,Silent.f3.sl(j)),min(1,Silent.f3.su(j))],'r:','LineWidth',2.0)
    end;
    for j=z0
    text(Silent.f3.fit(j),Silent.f3.pfit(j),int2str(j),'Color','b','HorizontalAlignment','Center','FontSize',14)
    %   text(fit(j),pnorm(fit(j),0,1),int2str(j),'Color','b','HorizontalAlignment','Center')
    plot([Silent.f3.fit(j),Silent.f3.fit(j)],[max(0,Silent.f3.sl(j)),min(1,Silent.f3.su(j))],'b:','LineWidth',2.0)
    end;
    title('Fitted classification probabilities and outcomes')
    xlabel('Metagene score');
    ylabel('Probability');
    hold off;
end;
if (Silent.f4.use > 0) 
    figure(5); set(gca,'FontSize',14); 
    plot([min(Silent.f4.fit) max(Silent.f4.fit)],[.5 .5],'black--','LineWidth',1);
    z=Silent.f4.ivalid; ZZ=Silent.f4.Z(Silent.f4.ivalid); z0=z(ZZ==0); z1=z(ZZ==1); z2=z(ZZ>1);
    hold on;
    for j=z1
        text(Silent.f4.fit(j),Silent.f4.pfit(j),int2str(j),'Color','r','HorizontalAlignment','Center','FontSize',14)
        plot([Silent.f4.fit(j),Silent.f4.fit(j)],[max(0,Silent.f4.sl(j)),min(1,Silent.f4.su(j))],'r:','LineWidth',2.0)
    end;
    for j=z0
        text(Silent.f4.fit(j),Silent.f4.pfit(j),int2str(j),'Color','b','HorizontalAlignment','Center','FontSize',14)
        %  text(fit(j),pnorm(fit(j),0,1),int2str(j),'Color','b','HorizontalAlignment','Center')
        plot([Silent.f4.fit(j),Silent.f4.fit(j)],[max(0,Silent.f4.sl(j)),min(1,Silent.f4.su(j))],'b:','LineWidth',2.0)
    end;
    for j=z2
        text(Silent.f4.fit(j),Silent.f4.pfit(j),int2str(j),'Color','black','HorizontalAlignment','Center','FontSize',14)
        %  text(fit(j),pnorm(fit(j),0,1),int2str(j),'Color','b','HorizontalAlignment','Center')
        plot([Silent.f4.fit(j),Silent.f4.fit(j)],[max(0,Silent.f4.sl(j)),min(1,Silent.f4.su(j))],'black:','LineWidth',2.0)
    end;
    title('CV probabilities: Validation cases')
    xlabel('Metagene score'); ylabel('Probability'); hold off;
end;
if (Silent.f5.use > 0)
    ci=Silent.f5.ci; 
    fitcv=Silent.f5.Fitcv; pfitcv=mean(Silent.f5.Pfitcv,2); 
    slcv=prctile(Silent.f5.Pfitcv',ci/2)'; sucv=prctile(Silent.f5.Pfitcv',100 - ci/2)';
    figure(6); set(gca,'FontSize',14); 
    plot([min(fitcv) max(fitcv)],[.5 .5],'black--','LineWidth',1);
        hold on;
        z=Silent.f5.itrain; ZZ=Silent.f5.Z(Silent.f5.itrain); z0=z(ZZ==0); z1=z(ZZ==1); 
        for j=z1
            text(fitcv(j),pfitcv(j),int2str(j),'Color','r','HorizontalAlignment','Center','FontSize',14)
            plot([fitcv(j),fitcv(j)],[max(0,slcv(j)),min(1,sucv(j))],'r:','LineWidth',2.0)
        end;
        for j=z0
            text(fitcv(j),pfitcv(j),int2str(j),'Color','b','HorizontalAlignment','Center','FontSize',14)
            plot([fitcv(j),fitcv(j)],[max(0,slcv(j)),min(1,sucv(j))],'b:','LineWidth',2.0)
        end;
        title('CV probabilities and outcomes: Training sample')
        xlabel('Metagene score');
        ylabel('Probability');
        hold off;
end;

