function pairs(F,Z,ind,lind)
%  Pairwise scatterplots of arrays on Factors in F
%  Columns are arrays, rows are factors 
%  with numbers and coloured according to one of two groups in indicator Z
%  which can be 0,1 or something else (=unclassified) 
%  ind selects columns of Z, and lind carries labels for numbering them 
 clf;
 set(gca,'FontSize',14); 
[p n]=size(F);
nn=1:n; n0=nn(Z==0); n1=nn(Z==1); n2=nn(~(Z==1|Z==0));
n=length(ind); 
a=min(F(ind,:)'); b=max(F(ind,:)'); del=(b-a)/8; a=a-del; b=b+del;
pic=1;
for i=1:(n-1)
  for j=(i+1):n
    subplot(n-1,n-1,pic)
    axis([a(j) b(j) a(i) b(i)]);
    hold on; 
    plot([a(j) b(j)],[0 0],'k:','LineWidth',1.5);
    plot([0 0],[a(i) b(i)],'k:','LineWidth',1.5);
    xlabel(['Factor ',int2str(ind(j))]);  ylabel(['Factor ',int2str(ind(i))]);
    for h=n1
      text(F(ind(j),h),F(ind(i),h),int2str(lind(h)),'Color','r','HorizontalAlignment','Center','FontSize',14)
    end;
    for h=n0
      text(F(ind(j),h),F(ind(i),h),int2str(lind(h)),'Color','b','HorizontalAlignment','Center','FontSize',14)
    end;
    for h=n2
      text(F(ind(j),h),F(ind(i),h),int2str(lind(h)),'Color','k','HorizontalAlignment','Center','FontSize',14)
    end;
    hold off;
    pic=pic+1;
  end;
  pic=pic+i;
end;
hold off;
% 

