function run_binreg(filename,nrm1, logged, nrm2)


[pathstr,name,ext,versn] = fileparts(filename);
if strcmp(ext,'.xls')
  [x, txt] = xlsread(filename);
  g1 = size(txt); g2 = size(x); 
  fprintf('\n Data imported from Excel:\n');
  fprintf('    %d X %d matrix of gene expression\n', g2(1)-1, g2(2));
  if(g1(1)>=g2(1))
    fprintf('    First column of gene information used as row labels\n\n');
    Descriptions = char(txt((g1(1)-g2(1)+2):end,1));
  else
    fprintf('    Rows are labeled sequentially\n\n');
    Descriptions = strcat('Row ',num2str((1:size(x))'));
  end;
else
  x = load(filename); 
  g1 = size(x);
  fprintf('\n Data imported from Text:\n');
  fprintf('    %d X %d matrix of gene expression\n', g1(1)-1, g1(2));
  fprintf('    Rows are labeled sequentially\n\n');
  Descriptions = strcat('Row ',num2str((1:size(x))'));
end;

C_group=x(1,:); x(1,:)=[];
group = C_group; group(C_group==0) = 1;


if (nrm1 == 1) 
  m=median(x(:,group==1),2);
  x=quantnorm(x,m); 
  fprintf(' Columns quantile normalized;')
end;
if (logged == 0) 
  x=log2(x); x(x<1) = 1; 
  fprintf(' Data logged;')
end;
if (nrm2 == 1 & sum(group==2)>0) 
  x(:,group==2) = std_rows_to_y(x(:,group==2), x(:,group==1));
  fprintf(' Rows standardized by group;')
end;

fprintf('\n\n')


fprintf(' Writing data to file\n\n')

dlmwrite('normalizedX.txt',x)


