function [ind,s]=select_genes_cor(X,Z,k)
% takes Nxn expression matrix x, outcome n vector z, and selects "top k"
%   based on correlation with outcome 
% Returns order vector and correlations in s in original order

 [N,n]=size(X); Y=reshape(Z,1,n); %Y is Z reshaped into a 1xn matrix
 v=std(X')'; i=find(v>1e-12); r=length(i); s=zeros(N,1); 
 s(i)=(sum(X(i,:).*repmat(Y,r,1),2)-n*mean(X(i,:),2)*mean(Y))./(n*v(i)*std(Z));  
 [b,i]=sort(abs(s)); i=flipud(i); ind=i(1:k)'; 
 
