function [ idx ] = affProp( S, ss, lam )
% computes the best exemplars based on the similarity matrix provided.
% The optional parameter, ss, defines self-similarity.  A lower number
% leads to a lower number of clusters.  Its default value is median(S(:)).
% The return value is a vector containing the exemplar for item 'i' in
% its ith entry.

if(nargin<3)
    lam=.5;
end;
if(nargin<2)
    ss=median(S(:));
end;
N=size(S,1);
de=(1:N)+((1:N)-1)*N;
S(de)=ss;
% S=S+1e-12*randn(N,N)*(max(S(S(:)~=Inf)))-min(S(S(:)~=-Inf));

A=zeros(N,N);
R=zeros(N,N);
idxOld=(1:N)';
for(iter=1:1000)
    % Compute responsibilities 
    Rold=R; 
    AS=A+S; [Y,I]=max(AS,[],2); 
    for i=1:N AS(i,I(i))=-realmax; end; 
    [Y2,I2]=max(AS,[],2); 
    R=S-repmat(Y,[1,N]); 
    for i=1:N R(i,I(i))=S(i,I(i))-Y2(i); end; 
    R=(1-lam)*R+lam*Rold; % Dampen responsibilities 
    % Compute availabilities 
    Aold=A; 
    Rp=max(R,0); for k=1:N Rp(k,k)=R(k,k); end; 
    A=repmat(sum(Rp,1),[N,1])-Rp; 
    dA=diag(A); A=min(A,0); 
    A(de)=dA;
    A=(1-lam)*A+lam*Aold; % Dampen availabilities 
    if(mod(iter,10)==0)
        E=R+A; % Pseudomarginals 
        I=find(diag(E)>0); K=length(I); % Indices of exemplars 
%         [jnk I]=max(E,[],2); I=sort(unique(I)); K=length(I);
        [tmp c]=max(S(:,I),[],2); c(I)=1:K; idx=I(c); % Assignments
%         if(length(idx)~=size(S,1))
%             'index is not full'
%             idx;
%         elseif(sum(idxOld==idx)==length(idx))
        if(length(idx)==size(S,1))
            if(sum(idxOld==idx)==length(idx))
    %             ['Completing after ' num2str(iter) ' steps: convergence']
                return;
            else
                idxOld=idx;
            end;
        end;
%         sum(diag(R+A)>0)
    end;
%     figure(1)
%     imagesc(A);
%     figure(2)
%     imagesc(R);
%     figure(3)
%     imagesc(A+R);
%     pause  
end;
['Completing after ' num2str(iter) ' steps: maximum # steps reached']
E=R+A; % Pseudomarginals 
I=find(diag(E)>0); K=length(I); % Indices of exemplars 
[tmp c]=max(S(:,I),[],2); c(I)=1:K; idx=I(c); % Assignments 
