function [ output_args ] = compareCGH( facPth )
%COMPARECGH Compare a given set of factors to known CGH data

dataPth=[{'D:\dataRepository\tissueSamples\breast\gray\rma.txt.dfm'};
    {'D:\dataRepository\cellLines\gray\rma.txt.dfm'}];
cghPth=[{'D:\dataRepository\tissueSamples\breast\gray\20080306-tumorCgh.txt'};
    {'D:\dataRepository\cellLines\gray\20080306-cgh.txt'}];
names=[{'Tumors'};
    {'Cell Lines'}];

minimum=[];
minLoc=[];
chrList=[];
kbList=[];
fac=[];
allmn=[];
cghList=[];
pList=[];

for(j=1:length(dataPth))
    ['computing factors: ' char(dataPth(j))]
    [tumorFac tumorids] = getFacScores( facPth, char(dataPth(j)) );
    ['loading ' char(cghPth(j))]
    cghDat=importdata(char(cghPth(j)));
    [jnk ord]=sortrows(cghDat.data(:,1:2),[1 2]);
    cghDat.data=cghDat.data(ord,:);
    cghDat.textdata(2:end,:)=cghDat.textdata(ord+1,:);
    cghSids=cghDat.textdata(1,5:end)';
    cghIds=cghDat.textdata(2:end,1);
    chrList=[chrList {cghDat.data(:,1)}];
    cgh=cghDat.data(:,4:end);
    cghKb=cghDat.data(:,2);

    [a b c]=intersect(tumorids,cghSids);
    tumorFac=tumorFac(b,:);
    cgh=cgh(:,c)';
    clear cghSids;
    tumorids=tumorids(b);

    'computing factor-cgh correlations.'
    [r p]=corr(tumorFac,cgh,'type','kendall','rows','pairwise');
    [mn mnLoc]=min(p,[],2);
    allmn=[allmn mn];
    cghList=[cghList {cgh}];
    kbList=[kbList {cghKb}];
    fac=[fac {tumorFac}];
    minimum=[minimum {mn}];
    minLoc=[minLoc {mnLoc}];
    pList=[pList {p}];
end;
allmn=min(allmn,[],2);
for(i=1:size(tumorFac,2))
    if(allmn(i)<(.01/size(p,2)))
        clf;
        for(j=1:length(dataPth))
            cgh=cghList{j};
            mnLoc=minLoc{j};
            mn=minimum{j};
            tumorFac=fac{j};
            chr=chrList{j};
            cghKb=kbList{j};
            p=pList{j};
%             figure(2*j-1);
            subplot(length(dataPth),4,(j-1)*4+1);
            plot(cgh(:,mnLoc(i)),tumorFac(:,i),'ok','markersize',10,'linewidth',3);
            set(gca,'fontsize',16);
            xlabel([char(cghIds(mnLoc(i))) ' ' num2str(chr(mnLoc(i))) '-' num2str(cghKb(mnLoc(i)))],'fontsize',16);
            ylabel(['Expression, factor ' num2str(i)],'fontsize',16);
            yl=ylim();
            xl=xlim();
            text(xl(1)*.9+xl(2)*.1,yl(1)*.1+yl(2)*.9,['p = ' num2str(mn(i))],'fontsize',16)
%             saveas(gcf,['factor' num2str(i) '-' char(names(j)) '-best.png']);
            
%             figure(2*j);
%             clf
            subplot(length(dataPth),4,((j-1)*4+2):((j-1)*4+4))
            [a b c]=unique(chr);
            chrLoc=chr+cghKb./(cghKb(b(c))+100)-.5;
            hold on;
            even=find(mod(chr,2)==0);
            odd=find(mod(chr,2)==1);
            sig=find(p(i,:)<.01/size(p,2));
            sig5=find(p(i,:)>.01/size(p,2) & p(i,:)<.05/size(p,2));
            plot(chrLoc(even),-log(p(i,even)),'.k');
            plot(chrLoc(odd),-log(p(i,odd)),'.b');
            plot(chrLoc(sig),-log(p(i,sig)),'.r');
            plot(chrLoc(sig5),-log(p(i,sig5)),'.m');
            hold off;
            xlim([.5 23.5]);
%             hold on;
%             plot(find(chr==chr(mnLoc(i))),-log(p(i,chr==chr(mnLoc(i)))),'.r')
%             hold off;
%             [a b c]=unique(chr);
%             tmp=(b-[0; b(1:(end-1))])/2+[0; b(1:(end-1))];
%             tmp(22)=[];
%             tm=1:23;
%             tm(22)=[];
%             set(gca,'XTick',tmp,'XTickLabel',tm)
            set(gca,'XTick',1:23);
            xlabel('Position in the Genome','fontsize',16)
            ylabel('-log(p-value) of correlation','fontsize',16)
            sigList=[char(cghIds(sig)) repmat(' ',length(sig),1) num2str(chr(sig)) repmat('-',length(sig),1) num2str(cghKb(sig))];
            dlmwrite(['factor' num2str(i) 'VS' char(names(j)) '-associations.txt'],sigList,'newline','pc','delimiter','');
        end;
%         saveas(gcf,['factor' num2str(i) '.png']);
        savefig(['factor' num2str(i)],'png');
%         pause;
    end;
end;

