function [ dir probeids ] = getFactors( path )
%GETFACTORS Summary of this function goes here
%   Detailed explanation goes here
cdir=pwd;
cd(path);
load mA.txt;
load mPostPib.txt;
load mPsi.txt;

parms=fopen('parameters.txt','r');
done=0;
nd=0;
while(done<2)
    tline=fgets(parms);
    if(tline== -1)
        'ERROR: parameters.txt is missing either NDesignVariables or NControlVariables.'
        break;
    end;
    if(findstr('NDesignVariables',tline)==1)
        tline(isspace(tline))=[];
        nd=nd+str2num(tline(18:end));
        done=done+1;
    elseif(findstr('NControlVariables',tline)==1)
        tline(isspace(tline))=[];
        nd=nd+str2num(tline(19:end));
        done=done+1;
    end;
end;
fclose(parms);

nc=size(mA,2);
dir=mA(:,(nd+1):end).*mPostPib(:,(nd+1):end)./repmat(mPsi',1,nc-nd);

probeids=cell(size(dir,1),1);
pids=fopen('probeids.txt','r');
for(i=1:length(dir))
    probeids(i)=cellstr(fgets(pids));
end;
fclose(pids);

cd(cdir);
