function decomp_plot(x,decomp,cfac,ifac,colfac)
% Plots x plus the first r(at most) series in decomp
% Customised version for BFRM - maintains colour codes for named components
%
  T=length(x); nk=size(decomp,1);
  mi=min(x);  ma=max(x);  d=1/(ma-mi);  h=0.02*T;
  cen=mean(d*(x-mi));
  plot(d*(x-mi)-cen,'color','k');  
  text(-3*h,0,'X','horizontalalignment','right');
  xlabel('Sample'); 
  box off;
  axis([-h T+h -1 nk+0.5+cen]);
  set(gca,'Xgrid','on');set(gca,'YTickLabel',' ')
  hold on; 
  for i=1:nk
      plot(-cen+i+d*(decomp(i,:)-mi),'color',colfac(i));
      if (ifac(i)>=0), ii=int2str(ifac(i)); else, ii=''; end 
      text(-3*h,i,[cfac(i),ii],'horizontalalignment','right');
  end;
  hold off;
%
