
function [ind]=imagecf(X,col,nfac,fsize)
% draws images of genes in x ordered by elements of A(:,1), or more 
%  than one eigenvector
%  for clarity, this version simply restricts to at most 4 images/evecs -- 
%  easy to modify if required; or use multiple times
% 
%  produces index vector for ordering rows one first factor as displayed 
%
if nargin==1 
   col='jet'; nfac=1; fsize=12; 
end
if nargin==2
   nfac=1; fsize=12;
end     
if nargin==3
   fsize=12;     
end
     

% mean zero the X data prior to SVD
	[m,k]=size(X); 
	[A,D,F]=svd0(X-repmat(mean(X,2),1,k));

% how many images? 
nr=1; nc=1; nf=length(nfac);
if (nf==2), nc=2; end; if (nf>2), nr=2; nc=2; end;
clf
for j=1:nf
        subplot(nr,nc,j);
 	[b,i]=sort(A(:,nfac(j))); i=flipud(i);  if (j==1), ind=i; end
        imagesc(X(i,:)); eval(['cmap ',col])
        ylabel(['Genes listed by factor ',int2str(nfac(j))],'fontsize',fsize); 
	xlabel('Samples','fontsize',fsize); 
end	


