function [y,ex]=predictDP(x,ig,m,mF,mA,mPsi,nh,ny,nf,Desig,alpha,mT,Tflag)
%
% Call: e.g.,
% y=predictDP(x(mVariablesIn,:),(1:10),4000,mF,mA,mPsi,nh,ny,nf,Desig,alpha);
%
% Simulates m draws from the approximate predictive factor distribution 
%    of residuals for genes in index vector ig 
% Counts response factors with latent factors
% Call: x is rawx data x(mVariablesIn,:) - only genes in model
%
  
  k=nf+ny;              %% OR USE to add regressors:  k=-1+size(mA,2);  
  li=(nh+1):size(mA,2); %% OR USE to add regressors:  li=2:size(mA,2);  
  n=size(mF,2); hi=(ny+1):size(mA,1); 
  B=mA(hi,li); F=mF(li,:); Psi=mPsi(hi); 
  ex=x-mA(hi,1)*mF(1,:);  mx=mA(hi,1);
% 
% restrict to chosen genes only
  ex=ex(ig,:);   B=B(ig,:); v=sqrt(Psi(ig)); [ng,n]=size(ex);
  desig=Desig(ig,:); mx=mx(ig); 
%
% now draw indicators of normal components; n+1 is new draw    %
  im=rdisc(m,[ones(n,1);alpha]/(alpha+n)); inew=find(im>n); im(inew)=[];  
  
  if (Tflag), cT=chol(mT); else, cT=eye(k); end 
  y=B*[ cT'*randn(k,length(inew)) F(:,im) ]+lprod(v,randn(ng,m));

% add in overall means for these genes ... for right scale 
  ex=ex+repmat(mx,1,n); y=y+repmat(mx,1,m);
  
  
  
