function [ output_args ] = setupBfrm( datPth, runDir, useProbes, corap )
%SETUPBFRM sets up BFRM for running outside of matlab

if(~exist(runDir,'dir'))
    'Directory does not exist.  Creating it.'
    mkdir(runDir);
end;
if(runDir(end)~='\')
    'Adding \ to the end of the runDir path.'
    runDir=[runDir '\'];
end;

copyfile('d:\bfrm\bin\bfrm.exe',runDir);
copyfile('d:\bfrm\bin\bfrm64',runDir);

tmp=importdata(datPth);
probeids=tmp.textdata(2:end,1);
% probeids=cellstr(num2str(tmp.data(1:end,1)));
sampleids=tmp.textdata(1,(end-size(tmp.data,2)+1):end)';
xpr=tmp.data;
clear tmp;

designHeader=cellstr('control');
   
H=ones(size(xpr,2),1);
[a b kp]=intersect(useProbes,probeids);
% kp=find(median(xpr,2)>8);

% if(corap)
%     cdat=cdt(kp,:);
%     %%% keep all genes, but put immune genes on top
%     tmp=rma(kp,:);
%     rma(kp,:)=[];
%     rma=[tmp; rma];
%     tmp=probeids(kp);
%     probeids(kp)=[];
%     probeids=[tmp; probeids];
%     S=abs(corr(cdat'));
%     idx=affProp(S,-2,.9);
%     uidx=unique(idx);
%     length(uidx)
%     idxCnt=zeros(length(uidx),1);
%     for(j=1:length(uidx))
%         idxCnt(j)=sum(idx==uidx(j));
%     end;
%     [jnk ord]=sort(idxCnt,'descend');
%     uidx=uidx(ord);
%     tmp=probeids(uidx);
%     probeids(uidx)=[];
%     probeids=[tmp;probeids];
%     tmp=rma(uidx,:);
%     rma(uidx,:)=[];
%     rma=[tmp;rma];
% end;

[p n]=size(xpr);
% if(length(kp)>400)
%     igenesin=double((1:p)'); 
%     evolutionarySearch=0;
%     nf=length(uidx);                       % number of latent factors
% else
    igenesin=sort(kp);
    evolutionarySearch=1;
    nf=0;
% end;

xmask=1*(isnan(xpr));
for(i=1:size(xpr,1))
    xpr(i,isnan(xpr(i,:)))=nanmean(xpr(i,:));
end;
nh=size(H,2);               % number of design vectors
iw=[];                      % weights
ny=0;                       % number of response variables
nbinreg=0;                  
nsurvreg=0;
ncont=0;
ncat=0;
nresps=[nbinreg nsurvreg ncont ncat];      
minpfac = 10;   % min number of genes in a factor
maxpin  = 20;   % max number of genes to pull in each step
maxf    = 20;   % max number of factors
maxp    = 700;   % stop when reach the first of maxp genes or maxf factors 
nit=1000;      % number of burnin steps
nmc=10000;     % number of MCMC iterates 
missingResponse=0;
missingCovariates=1;
nonGaussianFactors=1;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

save([runDir 'dataset.txt'],'xpr','-ASCII','-TABS');
save([runDir 'xmask.txt'], 'xmask', '-ASCII', '-TABS');
save([runDir 'varin.txt'], 'igenesin', '-ASCII', '-TABS');
save([runDir 'H.txt'], 'H', '-ASCII', '-TABS');
%     save iw.txt iw -ASCII -TABS 
dlmwrite([runDir 'probeids.txt'],char(probeids),'newline','pc','delimiter','');
dlmwrite([runDir 'sampleids.txt'],char(sampleids),'newline','pc','delimiter','');
dlmwrite([runDir 'des.txt'],char(designHeader),'newline','pc','delimiter','');

bfrm_setup


end

