function contourpoints(x,nc,ind,xscat,labs,ifig)
% Contours sample points
% 
% x     =     p.m array of m samples in p dimensions
% nc    =     number of contours chosen 
% ind   =     dimensions to be contoured - all pairs are contoured
% xscat =     index vector (if any) of points to scatter on contours
% labs  =     p dim cell array of character string variable labels (if present)
% ifig  =     figure handle (if present) 
%
if (nargin<3), 
    error('Not enough arguments'); 
end
if (nargin<6), 
    ifig=1;
    if (nargin<5),
        labs=cell(0,1); 
        for i=1:p, labs(i,:)=cellstr(['x(',int2str(i),')']); end
        if (nargin<4),
            xscat=[];  
        end
    end
end
ixscat=(length(xscat)>0); 
figure(ifig); clf
%
[p m]=size(x); 
n=length(ind); 
pic=1;
for i=1:(n-1)
  for j=(i+1):n
    subplot(n-1,n-1,pic) 
    ix=ind(i); iy=ind(j);   
    ax=[min(x(ix,:)) max(x(ix,:))]+[-1 1]*range(x(ix,:))/8;
    ay=[min(x(iy,:)) max(x(iy,:))]+[-1 1]*range(x(iy,:))/8;
    vX = linspace(ax(1),ax(2),10);
    vY = linspace(ay(1),ay(2),10);
    h=hist2d(x([iy ix],:)',vY,vX);
    vX=(vX(2:end)+vX(1:(end-1)))/2; vY=(vY(2:end)+vY(1:(end-1)))/2;
    contourf(vX,vY,h,nc); cmap('summer');
    hold on; 
    if (ixscat)
        scatter(x(ix,xscat),x(iy,xscat),'b+')
    end
    %axis([ax ay]);
    xlabel(char(labs(i,:))); ylabel(char(labs(j,:)));      
    hold off;
    pic=pic+1;
  end;
  pic=pic+i;
end;
% 
hold off;
% 

