
function ecdf_cell_plot(x)
%
% plots ECDF of a set of k samples in cell array X 
%

[k,r]=size(x); if r~=1, error('invalid cell array'); end
lc='brgmcyk';

clf;
for i=1:k
    z=sort(x{i,1})'; n=length(z); d=1/(n+1); 
    z=reshape(repmat(z,1,2)',1,2*n)'; 
    y=d*reshape(repmat((0:n)',1,2)',1,2*(n+1))'; y([1 end])=[]
    plot(z,y,'Color',lc(i)); 
    axis([min(z) max(z) 0 1])
    hold on
end
hold off

% 


