function cmap(map)
%
% MW's cover function for colormap that adds RG colours
%Color maps.
%
% MW utility cmpa.m adds 'rg' or 'gr' for green/red
%    hsv        - Hue-saturation-value color map.
%    hot        - Black-red-yellow-white color map.
%    gray       - Linear gray-scale color map.
%    bone       - Gray-scale with tinge of blue color map.
%    copper     - Linear copper-tone color map.
%    pink       - Pastel shades of pink color map.
%    white      - All white color map.
%    flag       - Alternating red, white, blue, and black color map.
%    lines      - Color map with the line colors.
%    colorcube  - Enhanced color-cube color map.
%    vga        - Windows colormap for 16 colors.
%    jet        - Variant of HSV.
%    prism      - Prism color map.
%    cool       - Shades of cyan and magenta color map.
%    autumn     - Shades of red and yellow color map.
%    spring     - Shades of magenta and yellow color map.
%    winter     - Shades of blue and green color map.
%    summer     - Shades of green and yellow color map.

if (nargin>0) 
   if(2==('rg'==map(1:2) | 'gr'==map(1:2))) 
	map=zeros(64,3); map(:,1)=flipud(((0:1:63)/63)'); map(:,2)=((0:1:63)/63)'; 
   end;
else
   map='jet'; 
end
colormap(map)




 
