function [ int ] = gqInt( a )
%GQINT gaussian quadrature integration.  Assumes that the interval of
%integration is -1 to 1 and the variable passed contains function
%evaluations at the points: -1/3*sqrt(5+2*sqrt(10/7)), - 1/3*sqrt(5-2*sqrt(10/7)),
%0, 1/3*sqrt(5+2*sqrt(10/7)), and 1/3*sqrt(5-2*sqrt(10/7)).

w=[(322-13*sqrt(70))/900; (322+13*sqrt(70))/900; 128/225; (322+13*sqrt(70))/900;(322-13*sqrt(70))/900];

if(size(a,1)==5)
    int=a'*w;
else
    int=a*w;
end;