function kmgroup(recur,relapse,a,q,showParticipants)
% draw KM curves for groups defined by bins of a into quantiles q
q=prctile(a,q); n=length(a); 
c=zeros(n,1); k=length(q); c(a>q(k))=k; 
if(nargin<5)
    showParticipants=0;
end;
for j=1:(k-1), c(a>q(j)&a<=q(j+1))=j; end
    li=repmat('-',1,k+1); col='cbmrkgycmbr';
%     col='kk';
    km([ recur 1-relapse c ],col,li);
%         title('KM by predicted risk group');
        axis([0 max(recur) 0 1]) 

if(showParticipants)
    atrisk = n + 1 - ranktrf(sort(recur)); 
    hold on;
    plot(sort(recur),atrisk/n,'color',[.5 .5 .5])
    hold off;
end;