function [ Sigma ] = mvNormalCov( Sigma0, mu0, df, kappa, z )
%updates the mean of a multivariate normal with prior mean mu0 (Px1), 
%prior precision matrix phiMu (PxP), and
%observations x (PxN) from distribution with precision matrix phiX (PxP).

[p n]=size(z);
mz=mean(z,2);
z=z-repmat(mz,1,n);
Sigma=iwishrnd(Sigma0+z*z'+kappa*n/(kappa+n)*(mz-mu0)*(mz-mu0)',df+n);
% Sigma=inv(wishrnd((V+V')/2,df+n));
