
function roccurve(pr,z,thr)

% plots roc curves given probs of events in pr and outcomes z
% marks thresholds in thr (all %s) 

clf; axis([0 1 0 1])
	xlabel('Specificity','FontSize',12); 
        ylabel('Sensitivity','FontSize',12) 
	% title('ROC curves (test positive->low survival prob)','fontsize',12)
        hold on
c=(1:99)/100; nc=length(c);  
  red= find(z==1); blu= find(z==0); nred=length(red); nblu=length(blu); 
  y=  sum(repmat(reshape(pr(red),nred,1),1,nc)>=repmat(c,nred,1))/nred;
  x=  sum(repmat(reshape(pr(blu),nblu,1),1,nc)< repmat(c,nblu,1))/nblu;   
  plot(x,y,'color','k'); 
  for j=1:length(thr)
     text(x(thr(j)),y(thr(j)),int2str(thr(j)),'color','r',...
	'horizontalalignment','center','FontSize',10); end
  grid on
hold off
