function [ data ] = scanData( file, delimiter, missing )
%SCANDATA reads the data in the provided file, treating variable in missing
%as NaN

if(nargin<2)
    delimiter=' ';
end;
if(nargin<3)
    missing='NA';
end;
if(length(delimiter)>1)
    'Delimiter must be a single character.'
    return;
end;

fid=fopen(file,'r');
nc=sum(strtrim(fgets(fid))==delimiter)+1;
fseek(fid,0,-1);
data=textscan(fid,repmat('%f',1,nc),'TreatAsEmpty',missing,'CollectOutput',1);
fclose(fid);
data=data{1};

end

