function [ out ] = scanfile( fPath, delim )
%SCANFILE Summary of this function goes here
%   Detailed explanation goes here

if(nargin==1)
    delim='\t';
end;

ids=fopen(fPath,'r');
if(ids==-1)
    'No such file.'
    out=-1;
    return;
end;
c=textscan(ids,'%s','delimiter','\n');
wl=deblank(c{1});
clear c;
fclose(ids);

c=length(regexp(char(wl(1)),delim))+1;
r=length(wl);
out=cell(r,c);
for(i=1:r)
    ln=char(wl(i));
    loc=regexp(ln,delim);
    loc=[0 loc length(ln)+1];
    for(j=1:c)
        out(i,j)=strtrim(cellstr(ln((loc(j)+1):(loc(j+1)-1))));
    end;
end;

