function [ fSnps pSnps nSnps ] = extractSigSnps( pth )
%EXTRACTSIGSNPS Summary of this function goes here
%   Detailed explanation goes here
cd(pth);
if(exist('./sigSnps.txt','file')==2 & exist('./fSnps.txt','file')==2 & exist('./pSnps.txt','file')==2)
    nSnps=readWordlist('sigSnps.txt');
    load fSnps.txt;
    load pSnps.txt;
else
    fred=ls();
    i=1;
    while(i<=size(fred,1))
        if(length(regexp(fred(i,:),'.adjusted'))==0)
            fred(i,:)=[];
        else
            i=i+1;
        end;
    end;
    n=zeros(size(fred,1),1);
    for(i=1:size(fred,1))
        pd=regexp(fred(i,:),'\.');
        n(i)=str2num(fred(i,10:pd(2)));
    end;
    [jnk ord]=sort(n);
    fred=fred(ord,:);
    pSnps=[];
    fSnps=[];
    nSnps=[];
    for(i=1:size(fred,1))
        x=importdata(fred(i,:));
        snps=x.textdata(2:end,2);
        kp=find(x.data(:,3)<.5);
        fSnps=[fSnps; repmat(i,length(kp),1)];
        pSnps=[pSnps; x.data(kp,3)];
        nSnps=[nSnps; snps(kp)];
    end;
    dlmwrite('sigSnps.txt',char(nSnps),'newline','pc','delimiter','');
    save fSnps.txt fSnps -ASCII -TABS;
    save pSnps.txt pSnps -ASCII -TABS;
end;