% Look at variables (genes) selected and estimated coeffs of them in top k models, with
% predictions from each and the model average over top k models.  Also
% compute the corresponding conditional variable inclusion probabilities


X=standardize(x); 
% X=x;
Fit=zeros(n,k); pFit=zeros(n,k);                    % to save fits and predictions 
pmp=zeros(N,1);                                     % to save marginal inclusive probs
figure(1); clf

for j=1:k
% for j=32
      p=models(j,1);                        % dim of this model
      if (p>0) 
          ig=models(j,2+(1:p));                 % predictors in model    
%           Des(ig,:)
%           ['Log-likelihood: ' num2str(models(j,2))]
          pmp(ig)=pmp(ig)+pm(j);         	    % save posterior probs on predictors 
          b=models(j,3+p+(0:p))';               % post mean of regn parameters
          A=[ones(n,1) X(:,ig)];          	    % design matrix
      else
          b=models(j,3); A=[ones(n,1)];
      end    
      Fit(:,j)=A*b;                         % fitted & predicted linear regn
      pFit(:,j)=1./(1+exp(-Fit(:,j)));        %    ... and plug-in probabilities
%       pFit(:,j)=glmval(glmfit(Fit(:,j),[y ones(size(y))],'binomial','link','probit'),Fit(:,j),'probit','size',ones(size(y)));

% predictions for hold-out validation cases are already in the above
%      figure(1)
%      ShowGenetv(pFit',y,itrain,ivalid,j); hold on; plot([0 n+1],[1 1]*sum(y)/n,'k:'); hold off
%      set(gca,'fontsize',16);
%      title(['Model ',int2str(j),': Prob=',num2str(pm(j),2)])
%      if (length(ivalid)>0),
%          legend('obs 0','obs 1','pred 0','pred 1','base','location','NorthEastOutside') 
%      else
%          legend('obs 0','obs 1','base','location','NorthEastOutside')
%      end
%      legend boxoff
%      figure(2)
%      plotCandida(pFit(:,j));
%      pause;
end

avepFit=pFit*pm(1:k)/sum(pm(1:k));
clf;
subplot(1,2,1);
plotGroups(avepFit,y,w);
xlim([0 length(y)+1]);
set(gca,'fontsize',16,'linewidth',2,'box','on');
ylabel('Fitted Probability','fontsize',16);
% if (length(ivalid)>0),
%  legend('obs 0','obs 1','pred 0','pred 1','location','NorthEastOutside') 
% else
%  legend('obs 0','obs 1','location','NorthEastOutside')
% end
subplot(1,2,2)
[tp fp a]=roc(y, avepFit);
plot(fp,tp,'linewidth',2)
set(gca,'fontsize',16,'linewidth',2,'box','on');
xlabel('False Positive','fontsize',16);
ylabel('True Positive','fontsize',16);
xl=.2;
yl=.1;
text(xl,yl,['area = ' num2str(a,2)],'fontsize',16);
% legend boxoff
% figure(2)
% plotCandida(avepFit);
    
[a,i]=sort(pmp,'descend'); 
vList=[ num2str(pmp(i),2) repmat('  ',length(i),1) Des(i,:) ];
['Kruskal-Wallis p=' num2str(kruskalwallis(avepFit,y,'off'))]
clear b A ig p a i 

