% Look at variables selected and estimated coeffs of them in top k models, with
% predictions from each and the model average over top k models.  Also
% compute the corresponding conditional variable inclusion probabilities

% note that the SSS models have x and y variables all standardised

[n,N]=size(x);
X=standardize(x); my=mean(y); sy=std(y); Y=(y-my)/sy;

Fit=zeros(n,k);   sig=zeros(1,k); df=zeros(1,k);    % to save fits and predictions 
pmp=zeros(N,1);                                     % to save marginal inclusive probs
tau=1; del=3; 
aa=[min(y) max(y)];

for j=1:k
    p=models(j,1); 			            % dim of this model
    if(p>0) 
        ig=models(j,2+(1:p));                 % predictors in model    
        pmp(ig)=pmp(ig)+pm(j);         	    % save posterior probs on predictors 
        b=models(j,2+p+(1:p))';               % post mean of regn parameters
        A=X(:,ig);                    	    % design matrix 
        %  b=(A'*A+eye(p+1)*tau)\(A'*y');    % regn para post mean computed 
    else
        A=0;b=0;
    end
    sig(j)=models(j,end-1); df(j)=models(j,end);
    Fit(:,j)=my+sy*(A*b);                 % fitted & predicted linear regn
%     Fit(:,j)=my+A*b;
    % predictions for hold-out validation cases are already in the above
%     clf; 
%     if (p>0)
%         figure(1)
%         clf;
%         plot(Fit(w==0,j),y(w==0),'x','markersize',10,'linewidth',3)
%         hold on;
%         plot(Fit(w==1,j),y(w==1),'or','markersize',5,'linewidth',3)
%         plot(aa,aa,'k:','linewidth',3);
%         hold off;
%         xlabel('Model Fit','fontsize',16);ylabel('Data','fontsize',16);
%         set(gca,'fontsize',16,'linewidth',2)
%         legend('Validation Data','Training Data','location','NorthWest')
%     else
%         ii=ones(1,n); ii(ivalid)=0; ShowGene(y',ii,1)
%     end
%     pause;
end

aveFit=Fit*pm(1:k)/sum(pm(1:k)); clf
clf;
plot(aveFit(w==0),y(w==0),'x','markersize',10,'linewidth',3)
hold on;
plot(aveFit(w==1),y(w==1),'or','markersize',5,'linewidth',3)
plot(aa,aa,'k:','linewidth',3);
hold off;
xlabel('Model Fit','fontsize',16);ylabel('Data','fontsize',16);
set(gca,'fontsize',16,'linewidth',2,'box','on')
      
[a,i]=sort(pmp,'descend'); 
vList=[ num2str(pmp(i),2) repmat('  ',length(pmp),1) Des(i,:) ];

