function [ mFit vList ] = sss( y,x,w )
%SSS Summary of this function goes here
%   Detailed explanation goes here

drp=find(sum(x==1)==size(x,1));
if(length(drp)>0)
    'Including a column of ones in x is unnecessary.'
    x(:,drp)=[];
end;

if(nargin<3)
    w=ones(size(y,1),1);
end;

itrain=(1:length(w));
ivalid=find(w==0);
itrain(ivalid)=[];

drp=find(sum(isnan([y,x]),2)>0);
y(drp,:)=[];
x(drp,:)=[];
w(drp,:)=[];

cdir=pwd();

%%% add test here to make sure that r and y are right.
if(size(y,2)>2)
    'y should have one column for binary or linear regression or two columns for survival models.'
    return;
end;
if(size(y,2)==2)
    r=y(:,2);
    y=y(:,1); 
    'y has two columns, assuming survival model'
end;    

lines=[];
variables=[
    {'NOBSERVATIONS'};
    {'NVARIABLES'};
    {'DATAFILE'};
    {'OUTFILE'};
    {'RESPONSEFILE'};
    {'WEIGHTSFILE'};
    {'ITEROUT'};
    {'SUMMARYFILE'};
    {'CENSORFILE'};
    {'NOISY'};
    {'NORMSTAND'};
    {'DSTART'};
    {'ONEVAR'};
    {'modtype'};
    {'iters'};
    {'NBest'};
    {'kmax'};
    {'innerAnneal1'};
    {'innerAnneal2'};
    {'innerAnneal3'};
    {'outerAnneal'};
    {'penalty'}
    ];

defaults=[
    {''};
    {''};
    {'data.txt'};
    {'models.txt'};
    {'responses.txt'};
    {'weights.txt'};
    {'iterout.txt'};
    {'modelsummary.txt'};
    {'NA'};
    {'1'};
    {'1'};
    {'2'};
    {'1'};
    {'1'};
    {'1000'};
    {'1000'};
    {''};
    {'0.6'};
    {'0.8'};
    {'1'};
    {'0.4'};
    {'1'}
    ];

if(exist('r'))    
    defaults(strcmp(variables,'modtype'))=cellstr('3');
elseif(all(y==0 | y==1))
    'All values in y are either 0, 1 or NaN. Assuming binary regression.'
    defaults(strcmp(variables,'modtype'))=cellstr('2');
end;    

defaults(strcmp(variables,'NOBSERVATIONS'))=cellstr(num2str(size(y,1)));
defaults(strcmp(variables,'NVARIABLES'))=cellstr(num2str(size(x,2)));
defaults(strcmp(variables,'kmax'))=cellstr(num2str(size(x,2)));

% if(exist('data.txt','file') | 
%     exist('models.txt','file') |
%     exist('responses.txt','file') |
%     exist('weights.txt','file') |
%     exist('iterout.txt','file') |
%     exist('modelsummary.txt','file') |
%     exist('sss.config.txt','file'))
%     'Some files in this directory will be overwritten. Ctrl-c to cancel.'
%     pause;
% end;

lines=cell(size(variables));
for(i=1:length(variables))
    lines(i)=cellstr([char(variables(i)) ' = ' char(defaults(i))]);
end;

cd d:\sss;

save(char(defaults(strcmp(variables,'DATAFILE'))), 'x', '-ascii', '-tabs');
save(char(defaults(strcmp(variables,'RESPONSEFILE'))), 'y', '-ascii', '-tabs');
save(char(defaults(strcmp(variables,'WEIGHTSFILE'))), 'w', '-ascii', '-tabs');
if(exist('r'))
    save(char(defaults(strcmp(variables,'CENSORFILE'))), 'r', '-ascii', '-tabs');
end;
dlmwrite('sss.config.txt',char(lines),'newline','pc','delimiter','');
!modelsearch sss.config.txt

[n N]=size(x);
Des=[repmat('Predictor ',size(x,2),1) num2str((1:size(x,2))')];
models=scanData(char(defaults(strcmp(variables,'SUMMARYFILE'))));
nm=size(models,1); pm=models(:,2);pm=exp(pm-max(pm));pm=pm/sum(pm);pmax=max(models(:,1)); 
k=min(c2n(defaults(strcmp(variables,'NBest'))),size(models,1));

if(c2n(defaults(strcmp(variables,'modtype')))==1)
    linfitpredict;
    mFit=aveFit;
elseif(c2n(defaults(strcmp(variables,'modtype')))==2)
    binaryfitpredict;
    mFit=avepFit;
elseif(c2n(defaults(strcmp(variables,'modtype')))==3)
    survivalsummary;
    mFit=aveFit;
end;

cd(cdir);
end

