function [ y ] = standardize( x, dim, robust )
%Standardize the columns of x.  If a second arguement is passed, it is
%interpreted as the dimension along which to standardize (2 to standardize
%the rows).

if(nargin<3)
    robust=0;
end;

if(nargin<2)
    dim=1;
end;

if(dim==2)
    x=x';
end;

m=size(x,1);
if(robust)
    y=x-repmat(nanmedian(x),m,1);
else
    y=x-repmat(nanmean(x),m,1);
end;

if(robust)
    scl=(quantile(y,.8)-quantile(y,.2))/2; i=find(scl<=0); scl(i)=1;
    y=y./repmat(scl,m,1);
else
    v=nanstd(y); i=find(v<=0); y(:,i)=0; v(i)=1; 
    y=y./repmat(v,m,1);
end;

if(dim==2)
    y=y';
end;