function subanalysis(file);

m = load(file);
n = m(2:end,:);

figA = figure(1); imagesc(n,[0,1]); colorbar;
saveas(figA,'heatmap','png');

euc = squareform(pdist(n'));

figB = figure(2); imagesc(euc,[0,3]); colorbar;
saveas(figB,'distances','png');
close all;

maxN = max(m(1,1:end));         % determine the number of subgroups
[r,c] = size(m);

for (i = 1:maxN)                % loop over all subgroups
	newM = [];                  % create an empty matrix to fill
	group = num2str(i);
    for (j = 1:c)                       % loop over the matrix of samples
		if ( m(1,j) == i )                      % identify samples that are from the subgroup to be analyzed
			newM = [m(2:end,j),newM];           % add them to the matrix
        end
    end
    
	fig1 = figure(1); imagesc(newM,[0,1]); colormap jet; colorbar;  % plot pathway predictions
	saveas(fig1,['subgroup-',group,'-heatmap'],'png');                  % save the plot
    
    eucD = squareform(pdist(newM'));                                 % calculate the euclidean distancesin the matrix     
    fig2 = figure(2); imagesc(eucD,[0,3]); colormap jet; colorbar;  % plot euclidean distances
    saveas(fig2,['subgroup-',group,'-distance'],'png');                 % save the plot
    
    close all;
end