"""

Functions:
get_tag
make_upstream_probe
make_downstream_probe
make_probes

"""

BEAD2TAG = {
    "LUA-1" : "CTTTAATCTCAATCAATACAAATC",
    "LUA-2" : "CTTTATCAATACATACTACAATCA",
    "LUA-3" : "TACACTTTATCAAATCTTACAATC",
    "LUA-4" : "TACATTACCAATAATCTTCAAATC",
    "LUA-5" : "CAATTCAAATCACAATAATCAATC",
    "LUA-6" : "TCAACAATCTTTTACAATCAAATC",
    "LUA-7" : "CAATTCATTTACCAATTTACCAAT",
    "LUA-8" : "AATCCTTTTACATTCATTACTTAC",
    "LUA-9" : "TAATCTTCTATATCAACATCTTAC",
    "LUA-10" : "ATCATACATACATACAAATCTACA",
    "LUA-11" : "TACAAATCATCAATCACTTTAATC",
    "LUA-12" : "TACACTTTCTTTCTTTCTTTCTTT",
    "LUA-13" : "CAATAAACTATACTTCTTCACTAA",
    "LUA-14" : "CTACTATACATCTTACTATACTTT",
    "LUA-15" : "ATACTTCATTCATTCATCAATTCA",
    "LUA-16" : "AATCAATCTTCATTCAAATCATCA",
    "LUA-17" : "CTTTAATCCTTTATCACTTTATCA",
    "LUA-18" : "TCAAAATCTCAAATACTCAAATCA",
    "LUA-19" : "TCAATCAATTACTTACTCAAATAC",
    "LUA-20" : "CTTTTACAATACTTCAATACAATC",
    "LUA-21" : "AATCCTTTCTTTAATCTCAAATCA",
    "LUA-22" : "AATCCTTTTTACTCAATTCAATCA",
    "LUA-23" : "TTCAATCATTCAAATCTCAACTTT",
    "LUA-24" : "TCAATTACCTTTTCAATACAATAC",
    "LUA-25" : "CTTTTCAATTACTTCAAATCTTCA",
    "LUA-26" : "TTACTCAAAATCTACACTTTTTCA",
    "LUA-27" : "CTTTTCAAATCAATACTCAACTTT",
    "LUA-28" : "CTACAAACAAACAAACATTATCAA",
    "LUA-29" : "AATCTTACTACAAATCCTTTCTTT",
    "LUA-30" : "TTACCTTTATACCTTTCTTTTTAC",
    "LUA-31" : "TTCACTTTTCAATCAACTTTAATC",
    "LUA-32" : "ATTATTCACTTCAAACTAATCTAC",
    "LUA-33" : "TCAATTACTTCACTTTAATCCTTT",
    "LUA-34" : "TCATTCATATACATACCAATTCAT",
    "LUA-35" : "CAATTTCATCATTCATTCATTTCA",
    "LUA-36" : "CAATTCATTTCATTCACAATCAAT",
    "LUA-37" : "CTTTTCATCTTTTCATCTTTCAAT",
    "LUA-38" : "TCAATCATTACACTTTTCAACAAT",
    "LUA-39" : "TACACAATCTTTTCATTACATCAT",
    "LUA-40" : "CTTTCTACATTATTCACAACATTA",
    "LUA-41" : "TTACTACACAATATACTCATCAAT",
    "LUA-42" : "CTATCTTCATATTTCACTATAAAC",
    "LUA-43" : "CTTTCAATTACAATACTCATTACA",
    "LUA-44" : "TCATTTACCAATCTTTCTTTATAC",
    "LUA-45" : "TCATTTCACAATTCAATTACTCAA",
    "LUA-46" : "TACATCAACAATTCATTCAATACA",
    "LUA-47" : "CTTCTCATTAACTTACTTCATAAT",
    "LUA-48" : "AAACAAACTTCACATCTCAATAAT",
    "LUA-49" : "TCATCAATCTTTCAATTTACTTAC",
    "LUA-50" : "CAATATACCAATATCATCATTTAC",
    "LUA-51" : "TCATTTCAATCAATCATCAACAAT",
    "LUA-52" : "TCAATCATCTTTATACTTCACAAT",
    "LUA-53" : "TAATTATACATCTCATCTTCTACA",
    "LUA-54" : "CTTTTTCAATCACTTTCAATTCAT",
    "LUA-55" : "TATATACACTTCTCAATAACTAAC",
    "LUA-56" : "CAATTTACTCATATACATCACTTT",
    "LUA-57" : "CAATATCATCATCTTTATCATTAC",
    "LUA-58" : "CTACTAATTCATTAACATTACTAC",
    "LUA-59" : "TCATCAATCAATCTTTTTCACTTT",
    "LUA-60" : "AATCTACAAATCCAATAATCTCAT",
    "LUA-61" : "AATCTTACCAATTCATAATCTTCA",
    "LUA-62" : "TCAATCATAATCTCATAATCCAAT",
    "LUA-63" : "CTACTTCATATACTTTATACTACA",
    "LUA-64" : "CTACATATTCAAATTACTACTTAC",
    "LUA-65" : "CTTTTCATCAATAATCTTACCTTT",
    "LUA-66" : "TAACATTACAACTATACTATCTAC",
    "LUA-67" : "TCATTTACTCAACAATTACAAATC",
    "LUA-68" : "TCATAATCTCAACAATCTTTCTTT",
    "LUA-69" : "CTATAAACATATTACATTCACATC",
    "LUA-70" : "ATACCAATAATCCAATTCATATCA",
    "LUA-71" : "ATCATTACAATCCAATCAATTCAT",
    "LUA-72" : "TCATTTACCTTTAATCCAATAATC",
    "LUA-73" : "ATCAAATCTCATCAATTCAACAAT",
    "LUA-74" : "TACACATCTTACAAACTAATTTCA",
    "LUA-75" : "AATCATACCTTTCAATCTTTTACA",
    "LUA-76" : "AATCTAACAAACTCATCTAAATAC",
    "LUA-77" : "CAATTAACTACATACAATACATAC",
    "LUA-78" : "CTATCTATCTAACTATCTATATCA",
    "LUA-79" : "TTCATAACTACAATACATCATCAT",
    "LUA-80" : "CTAACTAACAATAATCTAACTAAC",
    "LUA-81" : "CTTTAATCTACACTTTCTAACAAT",
    "LUA-82" : "TACATACACTAATAACATACTCAT",
    "LUA-83" : "ATACAATCTAACTTCACTATTACA",
    "LUA-84" : "TCAACTAACTAATCATCTATCAAT",
    "LUA-85" : "ATACTACATCATAATCAAACATCA",
    "LUA-86" : "CTAATTACTAACATCACTAACAAT",
    "LUA-87" : "AAACTAACATCAATACTTACATCA",
    "LUA-88" : "TTACTTCACTTTCTATTTACAATC",
    "LUA-89" : "TATACTATCAACTCAACAACATAT",
    "LUA-90" : "CTAAATACTTCACAATTCATCTAA",
    "LUA-91" : "TTCATAACATCAATCATAACTTAC",
    "LUA-92" : "CTATTACACTTTAAACATCAATAC",
    "LUA-93" : "CTTTCTATTCATCTAAATACAAAC",
    "LUA-94" : "CTTTCTATCTTTCTACTCAATAAT",
    "LUA-95" : "TACACTTTAAACTTACTACACTAA",
    "LUA-96" : "ATACTAACTCAACTAACTTTAAAC",
    "LUA-97" : "AATCTCATAATCTACATACACTAT",
    "LUA-98" : "AATCATACTCAACTAATCATTCAA",
    "LUA-99" : "AATCTACACTAACAATTTCATAAC",
    "LUA-100" : "CTATCTTTAAACTACAAATCTAAC",
    }

def normalize_bead_name(bead):
    if type(bead) is type(0):
        assert bead >= 0 and bead <= 99
        bead = "LUA-%d" % (bead+1)
    ubead = bead.upper()
    return ubead

def get_tag(bead):
    # bead is either a number from 0-99, or a name LUA-<1-100>.
    nbead = normalize_bead_name(bead)
    assert nbead in BEAD2TAG
    return BEAD2TAG[nbead]

def make_upstream_probe(gso_u, bead):
    # 20nt  Complement of the T7 universal primer site.
    # 24nt  barcode
    # 20nt  gene specific oligo (GSO).
    cT7_site = "TAATACGACTCACTATAGGG"
    barcode = get_tag(bead)
    return cT7_site + barcode + gso_u

def make_downstream_probe(gso_d):
    # 20nt  gene specific oligo (GSO).
    # 20nt  T3 universal primer site.
    T3_site = "TCCCTTTAGTGAGGGTTAAT"
    return gso_d + T3_site

def make_probes(gso_u, gso_d, bead):
    nbead = normalize_bead_name(bead)
    probe_u = make_upstream_probe(gso_u, nbead)
    probe_d = make_downstream_probe(gso_d)
    assert len(probe_u) == 64
    assert len(probe_d) == 40
    return nbead, probe_u, probe_d
