package charite.christo;
/**
   static constant values
   @author Christoph Gille
*/
import static java.awt.event.InputEvent.*;
public class ChConstants  {
    private ChConstants(){}
    public final static double LOG10=2.302585092994046;
    public final static int
        EM=9, EX=15, /* Default Font size 12 */
        CTRUE=1, CFALSE=-1,
        LENGTH_PDBIDS=4,
        CLOSE_ALLOWED=1<<0,
        CLOSE_DISPOSE=1<<1,
        CLOSE_CtrlW=1<<2,
        CLOSE_ESC=1<<3,
        CLOSE_RM_CHILDS=1<<4,
        CLOSE_CHILDS=1<<5,
        CLOSE_ASK=1<<6,
        CLOSE_NO_REMOVE=1<<7,
        CLOSE_DISPOSE_TABS=(1<<9)|CLOSE_DISPOSE,
        CLOSE_MASK=(1<<10)-1,
        CLOSE_CtrlW_ESC=CLOSE_CtrlW|CLOSE_ESC,
        DISPOSE_CtrlW=CLOSE_CtrlW|CLOSE_DISPOSE,
        INT_NAN=Integer.MIN_VALUE,
        MAX_INT=(1<<31)-1,
        MIN_INT=-(1<<31),
        DEFAULT_BACKGROUND=0xEEeeEE,
        BG_NOT_EDITABLE=DEFAULT_BACKGROUND,
        BG_TOGGLE_BUT=0xaaAAaa,
        COLOR_REF_GRAY=0xC0C0C0,
        COLOR_REF=0xFF,
        MASK_KEYMODIFIERS=(CTRL_MASK|SHIFT_MASK|ALT_MASK|ALT_GRAPH_MASK|META_MASK),
        ICON_HEIGHT=32;

    public final static String
        REGEX_NO_FILE_NAME="[^A-Za-z0-9+_.]",
        REP_PARENT_WINDOW="CC$$RPW",
        WATCH_MOVIE="WM_",
        MOVIE_Drag_to_another_STRAP="MOVIE:Drag_to_another_STRAP*",
        MOVIE_Load_Proteins="MOVIE:Load_Proteins*",
        MOVIE_Load_Proteins_web_uniprot="MOVIE:Load_Proteins_from_web_resource*",
        MOVIE_Export_Proteins="MOVIE:Export_Proteins*",
        MOVIE_Sequence_Features_in_3D="MOVIE:Sequence_Features_in_3D*",
        MOVIE_Context_Menu="MOVIE:Context_Menu*",
        MOVIE_Drag_protein_to_3D="MOVIE:Drag_protein_to_3D*",
        MOVIE_Load_Proteins_web_pdb="MOVIE:Load_Proteins_from_PDB_site*",
        LOG_SHOW="CEx$$L",
        IC_BOOK="book",
        IC_CENTER="center",
        IC_INFO="info",
        IC_LIST="list",
        IC_1="num1",
        IC_IMPORT="import",

        IC_CLIPBOARD="clipboard",
        IC_UNDERLINE="border_color",
        IC_COPY="copy",

        IC_ALIGN="formatting_right",
        IC_WINWORD="word",
        IC_FIT_TO_WIDTH="fit_to_width",
        IC_ANNO="attach",
        IC_BATCH="services",
        IC_COMPUTE="services",

        IC_BLANK="32x32",
        IC_TT="Forum_topic",
        IC_CAMERA="compact_camera",
        IC_COMPARE="scales",
        IC_KEYBOARD="keyboard",
        IC_CLOSE="close",
        IC_COILEDCOIL="coiledCoil",
        IC_COLOR="color",
        IC_BARCHART="barchart",
        IC_LED_GREEN16="ledgreen16",
        IC_CURSOR_HAND="cursor_hand",
        IC_DND="copy",
        IC_CONTROLPANEL=IC_CURSOR_HAND,
        IC_CUSTOM24="settings2_26",
        IC_CUSTOM="settings2",
        IC_TOOLS="settings2",
        IC_CYGWIN="cygwin",
        IC_RUNNING="running",
        IC_MOVIE="movie",
        IC_SEQUENCE="SEQU",
        IC_TM_HELIX="tmhelix",
        IC_DIRECTORY="folder",
        IC_CONSOLE="console",
        IC_DNA="dna_helix",
        IC_EDIT="edit",
        IC_WWW16="browser16",
        IC_WWW="globe",
        IC_WORD="word",
        IC_FLAVIN="flavin",
        IC_NOTEPAD="edit",
        IC_HAPPY="happy",
        IC_UNHAPPY="sad",
        IC_UNSURE="question",
        IC_LIKE="thumbs_up",
        IC_TUTORIAL="music_conductor",
        IC_HELIX="helix",
        IC_MITOCHONDRION="mitochon",
        IC_SHEET="prediction_E32x32",
        IC_SHOW="visible",
        IC_HIDE=IC_SHOW+ChIcon.SFX_CROSS_OUT,
        IC_SHOPPING="shoping_cart",
        IC_RESCUE="lifebuoy",
        IC_HOURGLASS="sandglass",
        IC_ADD="plus",
        IC_JAVA="outline",
        IC_JMOL="jmol",
        IC_PROTEASOME="proteasome",
        IC_KILL="delete",
        IC_SAVE_AS="save_as",
        IC_MAC_FINDER="mac_finder",
        IC_DOWNLOAD="download",
        IC_HOME="home",
        IC_ORIGINALCOORDINATES=IC_HOME,

        IC_PDF="pdf",
        IC_PLOT="line_chart",
        IC_PUBMED="pubmed",
        IC_UNIPROT="uniprot",
        IC_PLUGIN="lego",
        IC_PYMOL="pymol",
        IC_3D="3d",
        IC_ZIP="zip",
        IC_EXPORT="export",

        IC_SCISSOR="scissors",
        IC_SEARCH="search",
        IC_TO_END="end",
        IC_TO_START="skip_to_start",
        IC_STOP="stop",

        IC_SUPERIMPOSE="superimpose",
        IC_STRAP=IC_ALIGN,
        IC_DOTPLOT="dotplot",
        IC_SORT="SORT",
        IC_TRAFFICLIGHTGREEN="ledgreen16",
        IC_TREE="tree",
        IC_UMBRELLA="umbrella",
        IC_WWW_SETTINGS="wifi",
        IC_MEASURE="ruler",
        IC_SELECT="nui2",
        IC_HELP="help",
        IC_MAIL="new_post",
        IC_SECURITY="warning_shield",
        IC_TEXT_CURSOR="text_cursor",

        IC_MAC_OS="mac_os",
        IC_WINDOWS="windows",
    // echo -e '\033[35m'
        TOERR="TOERR",
        ANSI_UL="\u001B[4m",
        ANSI_BOLD="\u001B[1m",
        ANSI_RESET     ="\u001B[0m",
        ANSI_FG_BLACK  ="\u001B[30m",
        ANSI_FG_RED    ="\u001B[31m",
        ANSI_FG_GREEN  ="\u001B[32m",
        ANSI_FG_YELLOW ="\u001B[33m",
        ANSI_FG_BLUE   ="\u001B[34m",
        ANSI_FG_MAGENTA="\u001B[35m",
        ANSI_FG_CYAN   ="\u001B[36m",
        ANSI_FG_WHITE  ="\u001B[37m",

        ANSI_BLACK  ="\u001B[40m",
        ANSI_RED    ="\u001B[41m",
        ANSI_GREEN  ="\u001B[42m",
        ANSI_YELLOW ="\u001B[43m",
        ANSI_BLUE   ="\u001B[44m",
        ANSI_MAGENTA="\u001B[45m",
        ANSI_CYAN   ="\u001B[46m",
        ANSI_WHITE  ="\u001B[47m",
        ANSI_TERMINAL=ANSI_BLACK+ANSI_FG_GREEN,
        YELLOW_DEBUG=ANSI_YELLOW+"DEBUG> "+ANSI_RESET,
        BLUE_DEBUG=ANSI_BLUE+"DEBUG> "+ANSI_RESET,
        RED_ERROR=ANSI_MAGENTA+ANSI_RED+"Error"+ANSI_RESET+" ",
        RED_WARNING=ANSI_MAGENTA+ANSI_RED+"Warning"+ANSI_RESET+" ",
        RED_CAUGHT_IN=ANSI_RED+"Caught in"+ANSI_RESET+" ",
        GREEN_SUCCESS=ANSI_GREEN+"Success"+ANSI_RESET+" ",
        GREEN_AVAILABLE=ANSI_GREEN+"Available:"+ANSI_RESET+" ",
        GREEN_DONE=" "+ANSI_GREEN+"Done"+ANSI_RESET+" ",

        ANSI_W_ON_B=ANSI_FG_WHITE+ANSI_BLACK,
        ANSI_W_ON_R=ANSI_FG_WHITE+ANSI_RED,
        DIR_ANNOTATIONS="annotations",
        STRAPOUT="strapOut",
        STRAPTMP="strapTmp",
        TRASH="trash",

        _CC="charite.christo.",
        _CCP="charite.christo.protein.",
        _CCS="charite.christo.strap.",
        _CCM="charite.christo.metannogen.",
        _CCB="charite.christo.blast.",
        _CCSSC="charite.christo.strap.science.",
        _CCSE="charite.christo.strap.extensions.",
        CLASS_Pymol=_CCP+"Pymol",
        CLASS_Protein3d=_CCP+"Protein3d",
        CLASS_ChJmolPROXY=_CCP+"ChJmolPROXY",
        CLASS_ChAstexPROXY=_CCP+"ChAstexPROXY",
        CLASS_DialogSubcellularLocalization=_CCS+"DialogSubcellularLocalization",
        CLASS_DialogSimilarStructure=_CCS+"DialogSimilarStructure",
        CLASS_FlavinePROXY=_CCSSC+"FlavinePROXY",
        CLASS_MultipleAlignerKalign=_CCSE+"MultipleAlignerKalign",
        CLASS_Dialog3DViewer=_CCS+"Dialog3DViewer",
        CLASS_DialogNewProtein=_CCS+"DialogNewProtein",
        CLASS_DialogNeighbors=_CCS+"DialogNeighbors",
        CLASS_DialogAlignOneToAll=_CCS+"DialogAlignOneToAll",
        CLASS_DialogAlign=_CCS+"DialogAlign",
        CLASS_DialogPhylogeneticTree=_CCS+"DialogPhylogeneticTree",
        CLASS_DialogBarChart=_CCS+"DialogBarChart",
        CLASS_DialogCompareProteins=_CCS+"DialogCompareProteins",
        CLASS_DialogDifferentResidues=_CCS+"DialogDifferentResidues",
        CLASS_DialogDotPlot=_CCS+"DialogDotPlot",
        CLASS_DialogExportAlignment=_CCS+"DialogExportAlignment",
        CLASS_DialogExportProteins=_CCS+"DialogExportProteins",
        CLASS_DialogExportWord=_CCS+"DialogExportWord",
        CLASS_DialogFetchPdb=_CCS+"DialogFetchPdb",
        CLASS_DialogFetchSRS=_CCS+"DialogFetchSRS",
        CLASS_DialogGenbank=_CCS+"DialogGenbank",
        CLASS_DialogHighlightPattern=_CCS+"DialogHighlightPattern",
        CLASS_DialogImportMFA=_CCS+"DialogImportMFA",
        CLASS_DialogManyInOneRow=_CCS+"DialogManyInOneRow",
        CLASS_DialogPlot=_CCS+"DialogPlot",
        CLASS_DialogPredictSecondaryStructures=_CCS+"DialogPredictSecondaryStructures",
        CLASS_DialogPredictCoiledCoil=_CCS+"DialogPredictCoiledCoil",
        CLASS_DialogPredictTmHelices2=_CCS+"DialogPredictTmHelices2",
        CLASS_DialogRestoreFromBackup=_CCS+"DialogRestoreFromBackup",
        CLASS_DialogSelectionOfResiduesMain=_CCS+"DialogSelectionOfResiduesMain",
        CLASS_DialogSuperimpose3D=_CCS+"DialogSuperimpose3D",
        CLASS_Superimpose_LajollaProteinPROXY=_CCSE+"Superimpose_LajollaProteinPROXY",
        CLASS_Superimpose_CEPROXY=_CCSE+"Superimpose_CEPROXY",
        CLASS_Superimpose_LajollaRNA=_CCSE+"Superimpose_LajollaRNA",
        CLASS_DialogBlast=_CCS+"DialogBlast",
        CLASS_IntermediateSeq=_CCS+"IntermediateSeq",
        CLASS_Dialog_bl2seq=_CCS+"Dialog_bl2seq",
        CLASS_DialogInferCDS=_CCS+"DialogInferCDS",
        CLASS_DialogPredictTmHelicesMulti =_CCS+"DialogPredictTmHelicesMulti",
        CLASS_DnaExonStart=_CCS+"DnaExonStart",
        CLASS_EditDna=_CCS+"EditDna",
        CLASS_Prione=_CCSSC+"Prione",
        CLASS_Proteasome=_CCSSC+"Proteasome",
        CLASS_Texshade=_CCS+"Texshade",

        CLASS_DialogResidueAnnotationChanges=_CCS+"DialogResidueAnnotationChanges",
        CLASS_DialogCopyAnnotations=_CCS+"DialogCopyAnnotations",
        CLASS_DialogResidueAnnotationList=_CCS+"DialogResidueAnnotationList",
        CLASS_DialogNonRedundantSequenceSet=_CCS+"DialogNonRedundantSequenceSet",
        CLASS_Hyperrefs=_CC+"Hyperrefs",
        CLASS_DesktopUtils=_CC+"DesktopUtils",
        CLASS_StrapHotswap=_CCS+"StrapHotswap",

        CLASS_AlignmentWriterHSSP=_CCSE+"AlignmentWriterHSSP",
        CLASS_ConsensusSequence=_CCSE+"ConsensusSequence",
        CLASS_DemoAssociateObjectsToProteins=_CCSE+"DemoAssociateObjectsToProteins",
        CLASS_Distance3DToHetero=_CCSE+"Distance3DToHetero",
        CLASS_Distance3DToCursor=_CCS+"Distance3DToCursor",
        CLASS_AlignTwoProteinsAndGetScore=_CCSE+"AlignTwoProteinsAndGetScore",
        CLASS_AlignmentEntropy=_CCSE+"AlignmentEntropy",
        CLASS_ResidueHydrophobicity_TOPPRED=_CCSE+"ResidueHydrophobicity_TOPPRED",
        CLASS_ResidueValues_from_textfile=_CCSE+"ResidueValues_from_textfile",
        CLASS_ResidueSolventAccessibility=_CCSE+"ResidueSolventAccessibility",
        CLASS_Hydrophobicity=_CCSE+"Hydrophobicity",
        CLASS_CountResidues=_CCSE+"CountResidues",
        CLASS_MultipleAlignerClustalW=_CCSE+"MultipleAlignerClustalW",
        CLASS_Aligner3D=_CCS+"Aligner3D",
        CLASS_MultipleAlignerAmap=_CCSE+"MultipleAlignerAmap",
        CLASS_MultipleAlignerMafft=_CCSE+"MultipleAlignerMafft",
        CLASS_MultipleAlignerT_Coffee=_CCSE+"MultipleAlignerT_Coffee",
        CLASS_MultipleAlignerMuscle=_CCSE+"MultipleAlignerMuscle",
        CLASS_MultipleAlignerAlign_m=_CCSE+"MultipleAlignerAlign_m",
        CLASS_MultipleAlignerDialign=_CCSE+"MultipleAlignerDialign",
        CLASS_MultipleAlignerDialignT=_CCSE+"MultipleAlignerDialignT",
        CLASS_MultipleAlignerProbcons2=_CCSE+"MultipleAlignerProbcons2",
        CLASS_MultipleAligner_SPEM=_CCSE+"MultipleAligner_SPEM",
        CLASS_PairAlignerNeoBioPROXY=_CCSE+"PairAlignerNeoBioPROXY",
        CLASS_PairAlignerJAlignerPROXY=_CCSE+"PairAlignerJAlignerPROXY",
        CLASS_Superimpose_native_CE=_CCSE+"Superimpose_native_CE",
        CLASS_Superimpose_GangstaPlus=_CCSE+"Superimpose_GangstaPlus",
        CLASS_Superimpose_GoedePROXY=_CCSE+"Superimpose_GoedePROXY",
        CLASS_Superimpose_TM_align=_CCSE+"Superimpose_TM_align",
        CLASS_Aligner3D_Mapsci=_CCSE+"Aligner3D_Mapsci",
        CLASS_Aligner3D_Mustang=_CCSE+"Aligner3D_Mustang",
        CLASS_Aligner3D_Smolign=_CCSE+"Aligner3D_Smolign",
        CLASS_Aligner3D_Matt=_CCSE+"Aligner3D_Matt",
        CLASS_TransmembraneHelix_HMMTOP=_CCSE+"TransmembraneHelix_HMMTOP",
        CLASS_TransmembraneHelix_Phobius=_CCSE+"TransmembraneHelix_Phobius",
        CLASS_DialogPublishAlignment=_CCS+"DialogPublishAlignment",
        CLASS_TransmembraneHelix_TOPPRED=_CCSE+"TransmembraneHelix_TOPPRED",
        CLASS_TransmembraneHelix_ORIENTM=_CCSE+"TransmembraneHelix_ORIENTM",
        CLASS_TransmembraneHelix_SPLIT4=_CCSE+"TransmembraneHelix_SPLIT4",
        CLASS_TransmembraneHelix_SPLIT3=_CCSE+"TransmembraneHelix_SPLIT3",
        CLASS_TransmembraneHelix_SOSUI=_CCSE+"TransmembraneHelix_SOSUI",
        CLASS_TransmembraneHelix_DAS=_CCSE+"TransmembraneHelix_DAS",
        CLASS_TransmembraneHelix_PRED_TMR=_CCSE+"TransmembraneHelix_PRED_TMR",
        CLASS_TransmembraneHelix_TMHMM2=_CCSE+"TransmembraneHelix_TMHMM2",
        CLASS_TransmembraneHelix_TMAP=_CCSE+"TransmembraneHelix_TMAP",
        CLASS_TransmembraneHelix_TMPRED=_CCSE+"TransmembraneHelix_TMPRED",
        CLASS_TransmembraneHelix_MEMSAT=_CCSE+"TransmembraneHelix_MEMSAT",
        CLASS_TransmembraneHelix_WaveTM=_CCSE+"TransmembraneHelix_WaveTM",
        CLASS_TransmembraneHelix_THUMBUP=_CCSE+"TransmembraneHelix_THUMBUP",
        CLASS_TransmembraneHelix_TMAP_MULTI=_CCSE+"TransmembraneHelix_TMAP_MULTI",
        CLASS_SecondaryStructure_NNPREDICT=_CCSE+"SecondaryStructure_NNPREDICT",
        CLASS_SecondaryStructure_Sopma=_CCSE+"SecondaryStructure_Sopma",
        CLASS_SecondaryStructure_Jnet=_CCSE+"SecondaryStructure_Jnet",
        CLASS_CoiledCoil_PredictorRobinson=_CCSE+"CoiledCoil_PredictorRobinson",
        CLASS_Blaster_SOAP_ebi=_CCB+"Blaster_SOAP_ebi",
        CLASS_Blaster_web_ncbi=_CCB+"Blaster_web_ncbi",
        CLASS_Blaster_local_Wu=_CCB+"Blaster_local_Wu",
        CLASS_Blaster_local_NCBI=_CCB+"Blaster_local_NCBI",

        CLASS_Blaster_local_NCBI_gapped_PSI=_CCB+"Blaster_local_NCBI_gapped_PSI",
        CLASS_PhylogeneticTree_TreeTop=_CCSE+"PhylogeneticTree_TreeTop",
        CLASS_PhylogeneticTree_Archaeopteryx=_CCSE+"PhylogeneticTree_Archaeopteryx",
        CLASS_PhylogeneticTree_Jalview=_CCSE+"PhylogeneticTree_Jalview",

        CLASS_SuperimposeTwoStructuresAndGetScore=_CCSE+"SuperimposeTwoStructuresAndGetScore",
        CLASS_AlignmentScoreCountIdentical=_CCSE+"AlignmentScoreCountIdentical",
        CLASS_AlignmentScoreBlosume62=_CCSE+"AlignmentScoreBlosume62",

        URL_STRAP="http://www.bioinformatics.org/strap/",
        URL_STRAP_JNLP=URL_STRAP+"strap.jnlp",
        URL_STRAP_DOC=URL_STRAP+"doc/",
        URL_STRAP_JARS=URL_STRAP+"otherPackages/",
        URL_STRAP_DATAFILES=URL_STRAP+"dataFiles/",
        URL_STRAP_SRC=URL_STRAP+"SourcePackages/",
        URL_RCSB_IMAGES="http://www.rcsb.org/pdb/images/",
        TMP_DOWNLOAD_SFX="TMP",

        KOPT_NO_ICON="CC$$KNI",
        KOPT_SUPPORTS_CTRL_F="CC$$CtrlF",
        KOPT_DISABLE_EV="CC$$DEV",
        KOPT_CONTAINS_AA="CC$$CAA",
        KOPT_CONTAINS_NT="CC$$CNT",
        KOPT_DRAGS_PARWINDOW="CC$$KDPW",
        KOPT_NO_EVENT="CC$$NDE",
        KOPT_ALREADY_PAINTED="CC$$AP",
        KOPT_IS_SELECTED="CC$$IS",
        KOPT_UNDOCKABLE="CC$$UD",
        KOPT_DRAW_UNDOCKABLE="CC$$DUD",
        KOPT_IS_VALIDATE_ROOT="OPT$$IVD",
        KOPT_DO_NOT_INVALIDATE="OPT$$NIV",
        KOPT_DISABLE_IF_CHILDS_DISABLED="OPT$$DICD",
        KOPT_HIDE_IF_DISABLED="OPT$$HID",
        KOPT_NOT_PAINTED_IF_DISABLED="OPT$$NPID",
        KOPT_IS_IN_TABLE_HEADER="OPT$$TH",
        KOPT_NOT_FOR_MENUBAR="OPT$$NMB",
        KOPT_NOT_INDICATE_TOO_SMALL="OPT$$NITS",
        KOPT_TRACKS_VIEWPORT_WIDTH="OPT$$TVW",
        KOPT_TRACKS_VIEWPORT_HEIGHT="OPT$$TVH",

        KEY_FRAME_TITLE="CC$$FT",
        KEY_RUN_AFTER="CC$$RA",
        KEY_ENABLED_IF_ENABLED="CC$$EIE",
        KEY_OPTIONS="CC$$OPT",
        KEY_NO_PAINT_IF_ADJUSTING="CC$$NPIA",
        KEY_COLOR="CC$$KC",
        KEY_GET_VIEW="CC$$KGV",
        KEY_CTRL_PNL="CC$$CP",
        KEY_CACHE_TEXT="CC$$KTC",
        KEY_CONTEXT_OBJECTS="CC$$KCO",
        KEY_OPTS_SCROLLPANE="CC$$KSPO",
    //KEY_FIRST_PAINT_HOOK="CC$$FPH",
        ACTION_CHANGE_EVENT="CF$$SC",
        ACTION_TABLE_CHANGED="CC$$ATC",
        ACTION_CLICKED="CLICKED",
        ACTION_CLICKED_DOUBLE="CLICKED2",
        ACTION_CLICKED_AFTER_SUPER="CLICKED_AS",
        ACTION_CLICKED_DOUBLE_AFTER_SUPER="CLICKED2_AS",

        ACTION_COLOR_CHANGED="CC$$ACC",
        ACTION_CUSTOMIZE_CHANGED="CC$$CUST_C",
        ACTION_DATABASE_CLICKED="CC$$_DB_",
        ACTION_DELETE_OR_BACKSPACE="CC$$_D",
        ACTION_DOWNLOAD_PLUGIN="ACTION_DOWNLOAD_PLUGIN",
        ACTION_ENTER="CC$$_E",
        ACTION_FOCUS_GAINED="CC$$_FG",
        ACTION_FOCUS_LOST="CC$$__FL",
        ACTION_MENU_SELECTED="CC$$MENU_S",
        ACTION_SELECTION_CHANGED="CC$$ASC",
        ACTION_TEXT_CHANGED="CC$$_CH",
        ACTION_WINDOW_ACTIVATED="CF$$WACT",
        ACTION_WINDOW_CLOSING="CF$$WC",
        ACTION_WINDOW_DEACTIVATED="CF$$WDA",
        ARRAY_CP="CC$$ACP",
        CMD_CLEAR="CC$$CLR",
        CMD_MENU_SELECTION_CHANGED="CC$$MSC",
        CMD_MIDDLE_MOUSE_BUTTON="CC$$MMB",
        DO_NOT_ASK="DO_NOT_ASK",
        FEATURE_ACTIVE_SITE="Active_site",
        KEEP_DAYS_IN_CACHE="KEEP_DAYS_IN_CACHE=",
        KEY_ACCELERATOR="CC$$KAC",
        KEY_ACTION_COMMAND="CC$$AC",
        KEY_BACKGROUND="CC$$BG",

        KEY_CLASS_NAME="CC$$CLN",
        KEY_IMAGE_FILE_NAME="CC$$IFN",
        KEY_CLONED_FROM="CC$$CF",
        KEY_CLOSE_OPT="CC$$CO",
        KEY_CLONES="CC$$C",

        KEY_DEPENDS_ON="CC$$DO",
        KEY_CLOSE_HOOKS="CC$$D", /* Holding Disposable object or Runnable. Used in ChUtils#clos(..) */
    //KEY_DRAG_TARGET_DIRCTORY="CC$$KDTD",
        KEY_DROP_TARGET_REDIRECT="CC$$KDTR",
        KEY_DRAG_SRC_ID="CC$$DSID",

        KEY_EMAIL="email",
        KEY_ENABLED="CC$4",
        KEY_FEHLER_1="CC$$FEHLER_DOPPELT",
        KEY_FEHLER_2="CC$$FEHLER_DOPPELT",
        KEY_GET_MENUBAR="CC$$KMB",
        KEY_HIDE_IF_EXEC_FORBIDDEN="CC$DIEF",
        KEY_IF_EMPTY="CC$$EMPTY",
        KEY_IGNORE_SELECTION_EVT="CC$$ISE",
        KEY_IS_PRINTING="CC$IP",
        KEY_IS_RESIZING="CC$$IRS",
        KEY_LOOKS_LIKE_DIVIDER="CC$$LLD",
        KEY_MENU_ID="CC$$mid",
        KEY_MODEL="CC$$KM",
        KEY_MC="CC$$MC",
        KEY_NEEDS_REVALIDATE="CC$NR",

        KEY_NORTH_PANEL="CC$NP",
        KEY_SOUTH_PANEL="CC$SP",
        KEY_EAST_PANEL="CC$EP",
        KEY_WEST_PANEL="CC$WP",
        KEY_FRAME="CC$KF",

        KEY_NOT_YET_PAINTED="CC$$NYP",
        KEY_PANEL="CC$KP",
        KEY_PREF_SIZE="CC$$PRS",
        KEY_PRINTABLE_COMPONENTS="CC$$PRC",
        KEY_PROGRESS="CC$$PRGRS ",
        KEY_SCALE_FACTOR="CC$KSF",
        KEY_SCROLL_EVEN_IF_INVISIBLE="CC$$SEII",
        KEY_SCROLL_INCR_V="CC$$SI",

        KEY_TIP_LOCATION="CC$TL",
        KEY_TITLE="TITLE",
        KEY_TOOLTIP="CC$$TT",
        KEY_VISIBLE_COMPONENT="CC$$VC",
        MAY_PROVIDE_TREE_VALUE="$CCMPRC",
        OPAQUE_FALSE="CC$$OPAQ",
        OPAQUE_TRUE="CC$$OPAQt",
        PROVIDE_DND_FILES="CC$$PDnDF",

        PROVIDE_HIGHLIGHTS="CC$$pHL",
        PROVIDE_FILES="CC$$PFF",
        PROVIDE_JORTHO_WORD_LIST="CC$$jowl",
        PROVIDE_JPopupMenu="CC$$pCM",
        PROVIDE_JTREE_CHILDS="CC$$PJTC",
        PROVIDE_JTREE_NODE_ID="CC$$PJTNI",
        PROVIDE_TEXT_FOR_SORTING="CC$$PTSA",
        PROVIDE_WORD_COMPLETION_LIST="CC$$wcl",
        UNNAMED="unnamed",
        KEY_AVOID_GARBAGE_COLLECT="CC$$AGC",
        UPLOAD_DOC=
        "cd ~/.StrapAlign/; tar -czf doc.tgz doc/\n"+
        "scp  ~/.StrapAlign/doc.tgz $STRAP_DIR_B \n"+
        "SSH_B  'pushd  ~/public_html/strap/ &&  tar -xzf doc.tgz && popd ' \n";

    public final static char DOCTYPE_TUTORIAL='T',  DOCTYPE_HTML='H',  DOCTYPE_JAVADOC='J';

    public final static int
    /*--- Begin Thread when and how long last thread --- */
        DURATION=1,
        WHEN=0,
        ARRAY_DURATION=2,
        EDT=1,
        PAUSE=2,
    /* --- END Thread --- */
        LEN_PDB_ID=4,
        LEN_UNIPROT=6,
        HETERO_HOH=('H')+('O'<<8)+('H'<<16)+(' '<<24),
        HETERO_HHO=('H')+('H'<<8)+('O'<<16)+(' '<<24),
        HETERO_OHH=('O')+('H'<<8)+('H'<<16)+(' '<<24),
        HETERO_H2O=('H')+('2'<<8)+('O'<<16)+(' '<<24),
        HETERO_DOD=('D')+('O'<<8)+('D'<<16)+(' '<<24),
        HETERO_DDO=('D')+('D'<<8)+('O'<<16)+(' '<<24),
        HETERO_ODD=('O')+('D'<<8)+('D'<<16)+(' '<<24),
        HETERO_D2O=('D')+('2'<<8)+('O'<<16)+(' '<<24),
        HETERO_NA =' '+('N'<<8)+('A'<<16)+(' '<<24),
        HETERO_MG =' '+('M'<<8)+('G'<<16)+(' '<<24),
        HETERO_NM =' '+('N'<<8)+('M'<<16)+(' '<<24),
        HETERO_ZN =' '+('Z'<<8)+('N'<<16)+(' '<<24),
        HETERO_SE =' '+('S'<<8)+('E'<<16)+(' '<<24),
        HETERO_CO =' '+('C'<<8)+('O'<<16)+(' '<<24),
        HETERO_MN= ' '+('M'<<8)+('N'<<16)+(' '<<24),
        HETERO_NI =' '+('N'<<8)+('I'<<16)+(' '<<24),
        HETERO_FE =' '+('F'<<8)+('E'<<16)+(' '<<24),
        HETERO_CA =' '+('C'<<8)+('A'<<16)+(' '<<24),
        ATOM_CA =' '+('C'<<8)+('A'<<16)+(' '<<24),
        PROTEIN_MIN_FILE_SZE=10;

    /* ChTextComponents */
    public final static long
        ENABLE_EVT_MASK=MOUSE_EVENT_MASK|MOUSE_MOTION_EVENT_MASK|KEY_EVENT_MASK|MOUSE_WHEEL_EVENT_MASK|FOCUS_EVENT_MASK|ACTION_EVENT_MASK,

        HIGHLIGHT_STYLE_MASK=(1<<6)-1,
        HIGHLIGHT_STYLE_RRECT=1,
        HIGHLIGHT_STYLE_WAVE=2,
        HIGHLIGHT_STYLE_UL=3,
        HIGHLIGHT_IGNORE_CASE=1<<6,
        HIGHLIGHT_SKIP_BLANKS=1<<7,
        HIGHLIGHT_DOT_MATCHES_ANY=1<<8,
        HIGHLIGHT_IGNORE_LEN_OF_BLANK=1<<9,
        HIGHLIGHT_REMOVE_IF_TEXT_CHANGES=1<<10,
        HIGHLIGHT_UPDATE_IF_TEXT_CHANGES=1<<11, HIGHLIGHT_REPAINT=1<<12,
        HIGHLIGHT_NOT_IN_SCROLLBAR=1<<13,
        HIGHLIGHT_UPDATE_ON_MOUSE_ENTER=1<<14,
        HIGHLIGHT_NEVER_REMOVE=1<<15,
        ULREFS_PMID_DOWNLOAD=1<<11,
        ULREFS_GO=1<<12,
        ULREFS_BG=1<<15,
        ULREFS_NOT_CLICKABLE=1<<16, ULREFS_DISABLE=1<<17, ULREFS_DISABLE_UNTIL_MOUSE=1<<18, ULREFS_NO_ICON=1<<19,
        ULREFS_WEB_COLORS=1<<20,
        ULREFS_NEVER=1<<21,
        COMPLETION_DIRECTORY_PATH=1<<22,
        COMPLETION_FILES_IN_WORKING_DIR=1<<23;

    public final static double BUGFIX_OPENJDK_G2=1E-1;
}

