package charite.christo.test;
import charite.christo.*;
import charite.christo.strap.*;
import charite.christo.protein.*;
import java.awt.event.*;
import java.awt.*;
import java.io.*;

import java.net.URL;
import java.util.*;
import javax.swing.*;

import static charite.christo.ChUtils.*;
import static charite.christo.ChConstants.*;

public class DebugUtils implements ChRunnable, ActionListener {
    public final static String
        CNAME=_CC+"test.DebugUtils",
        FLAV_MB="flavMB",
        FLAVINE_ERGAENZE_PDB="flavineErgaenzePdb",
        BUTTON="button";

    private static DebugUtils _inst;
    public static DebugUtils inst() { if (_inst==null) _inst=new DebugUtils(); return _inst;}

    public Object run(String id,Object arg) {
        if (id=="OutOfMemoryError" || id=="EXEPT") {
            // try {
                if (id=="EXEPT") {
                    Object oo[]={null};
                    oo[4711]=null;
                }
                if (id=="OutOfMemoryError") throw new OutOfMemoryError();
                //} catch(Exception ex) { ex.printStackTrace();}
        }

        if (id=="SIM_EDT_VIOL") new JLabel(id);
        if (id=="SIM_COMPUT") ChThread.simulateLongComputation();
        return null;
    }
    public void actionPerformed(ActionEvent ev) {
        final Object q=ev.getSource();
        final String cmd=ev.getActionCommand();
        final StrapAlign align=StrapAlign.getInstance();
        final Protein ppV[]=StrapAlign.visibleProteins();
        if (cmd=="SHOW") show();
        /* Flavine */
        if (cmd=="SORT")  {
            if (!isCtrl(ev)) {
                final Protein pp[]=new ProteinsSorterMatrix().sortProteins(ppV,null);
                pcp("UNDO", ppV.clone(),q);
                align.inferOrderOfProteins(0,pp);
            } else align.inferOrderOfProteins(0,gcp("UNDO",q));

            if (cmd=="ASSERT") { assrt(); }
            if (cmd=="EXEPT") run(cmd, null);
            if (cmd=="SIM_COMPUT") startThrd(thrdCR(this, "SIM_COMPUT",NO_OBJECT));
        }
        final String path=delSfx(".list", delSfx(".LIST", toStrg(file(Strap.listFile()))));
        if (cmd=="WRITE_LIST") {
            final BA sb=new BA(999);
            for(Protein p : ppV) sb.aln(delSfx(".ent",delPfx("pdb",toStrg(p))));
            wrte(file(path+".list"),sb);
            putln(YELLOW_DEBUG+"listFile=",path,"\n");
            wrte(file(path+".LIST"), sb.clr().join(ppV,"\n").a('\n'));
            sb.clr();
            for(Protein p : align.getProteins()) {
                if (!cntains(p,ppV)) sb.aln(delSfx(".ent",delPfx("pdb",toStrg(p))));
            }
            if (sze(sb)>0) appndToFile("\n# "+Strap.listFile()+"\n"+sb, file("unsorted.proteins"));
            final Protein pCursor=align.cursorProtein();
            if (pCursor!=null) wrte(file(path+".pref"), pCursor+"\n");
        }
        /* Thread */
        if (cmd=="SIM_EDT_VIOL") thrdCR(this,cmd).start();
        if (cmd=="SIM_DEADL" && ChMsg.yesNo("Warning: Say yes only if you know what you are doing")) SimulateSynDeadLock.main(NO_STRING);
           /* Garbage */
        if (cmd=="DEBUG_GC") debugGC();
        /* UI */
        if (cmd=="UD_TREE") {
            if (isShift(ev)) StrapAlign.tree().updateUI(); else revalAndRepaintC(StrapAlign.tree());
        }
        if (cmd=="TEST_SOUND") testSounds();
        if (cmd=="ENCODING") {
            final String s=ChMsg.input("String?",40,"");
            final BA sb=new BA(99).a(s).a("  >  ");
            for(int i=0; i<sze(s); i++) {
                final char c=s.charAt(i);
                if (is(LETTR_DIGT_US_COLON,c)) sb.a(c);
                else sb.a(Integer.toHexString(c));
                sb.a(' ');
            }
            shwTxtInW(sb);
        }
        /* MC */
        if (cmd=="DEBUG_MC") debugMC(ppV);
        if (cmd=="JBUTTON")  testAquaButtonType();
    }

    public static Component[] flavMB() {
        return new Component[]{
            new ChButton("SORT").li(inst()),
            new ChButton("WRITE_LIST").li(inst()), /*FLAV*/
            new ChButton("FAD").r(new charite.christo.strap.science.HighlightFlavine())
        };
    }
    private static void flavineErgaenzePdb(String ss[]) { /*FLAV*/
        if (!myComputer()) return;
        for(int i=sze(ss); --i>=0;) {
            final String s=ss[i];
            if (sze(s)!=6  || chrAt(4,s)!='_' || !is(UPPR_DIGT_US,s,5) || !cntainsOnly(LETTR_DIGT,s,0,4)  ) continue;
            final String s2="pdb"+s+".ent";
            if (sze(file(s2))>0) {
                puts(onlyOnce(RED_WARNING+"flavineErgaenzePdb\n"));
                ss[i]=s2;
            }
        }
    }

    private static Object _pnl;
    public static Object button() { return new ChButton("SHOW").t("DebugUtils").li(inst());}
    public static void show() {

        if (_pnl==null) {
            final DebugUtils li=inst();
            _pnl=pnl(VBHB,
                     "Exception",
                     new ChButton("Simulate an exception ").r(thrdCR(li,"EXEPT")),
                     new ChButton("EXEPT").t("Simulate an exception in thread").li(li),
                     new ChButton("Simulate OutOfMemoryError").r(thrdCR(li,"OutOfMemoryError")),
                     new ChButton("ASSERT").t("Throw assertion error").li(li),

                     "EDT",

                     new ChButton("SIM_EDT_VIOL").t("Simulate EDT violation").li(li),
                     "Thread",

                     new ChButton("SIM_DEADL").t("Simulate dead lock").li(li),
                     new ChButton("SIM_COMPUT").t("Simulate time consuming computation of 10s").li(li),
                     "UI",
                     new ChButton("UD_TREE").t("Update tree").li(li).tt("revalidate: \nSHIFT: updateui"),
                     new ChButton("TEST_SOUND").t("Test sound").li(li),
                     new ChButton("ENCODING").t("Character encoding").li(li),
                     new ChButton("JBUTTON").li(li).t("Test JButton types ..."),
                     "MC",
                     new ChButton("DEBUG_MC").t("Print modi-ct").li(li),

                     ""
                     );
        }
        ChFrame.frame("DebugUtils", _pnl,ChFrame.PACK).shw(ChFrame.AT_CLICK);

    }

    public static void main(String argv[]) {

    }

    public static void debugGC() {
        final int n=sze(_vDebugGC);
        final Map<Class, int[]> map=new HashMap();
        putln(BLUE_DEBUG+" debugGC "+n);
        for(int i=n; --i>=0;) {
            final Object p=getRmNull(i,_vDebugGC);
            if (p==null) continue;
            if (p instanceof BA) {
                putln(BLUE_DEBUG+i+" debugGC "+sze(p)+"  "+((BA)p).bytes().length);
                final Object stckTrc=gcp("D",p);
                if (stckTrc!=null) putln(BLUE_DEBUG+"stckTrcAsStrg=",stckTrc);
            }
            int[] count=map.get(p.getClass());
            if (count==null) map.put(p.getClass(), count=new int[1]);
            count[0]++;
        }
        for(Map.Entry<Class, int[]> e : entryArry(map)) {
            putln(BLUE_DEBUG+" debugGC "+shrtClasNam(e.getKey())+" #"+e.getValue()[0]);
        }
    }
    public static void debugMC(Protein pp[]) {
        putln(ANSI_YELLOW+"Modi counts"+ANSI_RESET+"\n",intArrayToTxt(Protein.MC_GLOBAL),"\n");
        for(Protein p : pp) putln(intArrayToTxt((int[])p.run("MC",null)), " ",p);
    }
    public static void testAquaButtonType() {
        final String[] data= "default toolbar icontext".split(" ");
        final JComponent pnl=pnl(VB);
        for(String d : data) {
            final ChButton bb[]={new ChButton("Button"),new ChButton("B")};
            for(ChButton b :bb) b.putClientProperty("ChButton.buttonType",d);
            pnl.add(pnl(d," ",bb[0],bb[1]));
        }
        new ChFrame("Buttons").ad(pnl).shw(0L);
    }
    public static void testSounds() {
        ChMsg.sound(ChMsg.SOUND_SUCCESS);
        ChMsg.sound(ChMsg.SOUND_FAILURE);
        sleep(999);
        final String ss[]="FrameClose FrameMaximize FrameMinimize FrameRestoreDown FrameRestoreUp MenuItemCommand OptionPaneError OptionPaneInformation OptionPaneQuestion OptionPaneWarning PopupMenuPopup".split(" ");
        for(String s : ss) {
            final java.net.URL u=UIManager.class.getResource("plaf/metal/sounds/"+s+".wav");
            if (u!=null) { java.applet.Applet.newAudioClip(u).play(); sleep(500); } else assrt();
        }
    }

    public static String debugJComponent(Object o) {
        final BA sb=new BA(999);
        final JMenuBar mb=deref(o,JMenuBar.class);
        final Component[] cc=mb!=null ? childs(mb) : derefArray(oo(o),Component.class);
        putln(BLUE_DEBUG,mb!=null?"debugMenuBar(: ":"debugJComponent: "+sze(cc));
        for(Component c : cc) sb.a(' ').a(shrtClasNam(c)).a(' ').aln(getTxt(c));
        return sb.toString();
    }

    public final static Vector _vDebugGC=new Vector();
    public static void addDebugGc(Object o) {
        if (o!=null) {
            _vDebugGC.add(newWeakRef(o));
        }
    }

}
